/*
 *      $COPYRIGHT$
 *
 *	$Id: getworkdir.cc,v 1.1 2000/02/07 23:06:01 bbarrett Exp $
 *
 *	Function:	- get the user's current working directory
 *			- dynamically allocated space
 *			- use old getwd() for efficiency if possible
 *			- hopefully our MAX is bigger than everybody's MAX
 *			  (someday a _real_ standard will emerge!)
 *	Returns:	- working directory or NULL
 */

#include "lam.h"
#include "getworkdir.h"

#include <stdlib.h>
#include <unistd.h>

#define PATHSIZE	2048


char *
getworkdir()
{
  char *cwd;			       /* working directory name */

/*
 * Allocate a hopefully large enough buffer;
 */
  if ((cwd = (char*) malloc((unsigned) PATHSIZE)) == 0) {
    return ((char *) 0);
  }
/*
 * Get the working directory.  Work around SunOS bug.
 */

#if HAVE_GETCWD && !defined(SUNOS)
  if (getcwd(cwd, PATHSIZE)) {
#else
  if (getwd(cwd)) {
#endif

    return (cwd);
  } else {
    free(cwd);
    return ((char *) 0);
  }
}
