/*
 *      $COPYRIGHT$
 *
 *	$Id: trdrain_mpi.cc,v 1.2 2000/02/09 13:53:10 bbarrett Exp $
 *
 *	Function:	- unloads trace data for one MPI world
 *	Accepts:	- trace file desc. opened for append
 *			- GPS array of world
 *			- GPS array length
 *			- get/forget flag
 *			- delay period in secs after flush signal
 */

#include <unistd.h>

#include <lam_ksignal.h>
#include <app_mgmt.h>
#include <mpitrace.h>
#include <preq.h>
#include <trreq.h>
#include <typical.h>
#include "trdrain.h"

extern "C" {
typedef int (*drain_funct) (int4, int4, int4, int4);
}

int
trdrain_mpi(int fd, struct _gps *world, int nworld, 
	    int keep, int flush_delay)
{
  int i;

  drain_funct drain;

  drain = keep ? lam_rtrfget : lam_rtrfforget;
/*
 * Signal everybody to flush in-process trace buffers to the daemon.
 */
  if (flush_delay >= 0) {

    for (i = 0; i < nworld; i++) {
      rpdoom(world[i].gps_node, SELECT_PID,
	     world[i].gps_pid, LAM_SIGTRACE);
    }

    if (flush_delay > 0) {
      sleep((unsigned) flush_delay);
    }
  }
/*
 * Drain the init/on/off traces.
 */
  for (i = 0; i < nworld; i++) {

    if ((*drain) (world[i].gps_node, TRONOFF, world[i].gps_pid,
		  fd) < 0)
      return (LAMERROR);
  }
/*
 * Drain the communicator traces.
 */
  for (i = 0; i < nworld; i++) {

    if ((*drain) (world[i].gps_node, TRCOMM, world[i].gps_pid,
		  fd) < 0)
      return (LAMERROR);
  }
/*
 * Drain the datatype traces.
 */
  for (i = 0; i < nworld; i++) {

    if ((*drain) (world[i].gps_node, TRDTYPE, world[i].gps_pid,
		  fd) < 0)
      return (LAMERROR);
  }
/*
 * Drain the runtime traces.
 */
  for (i = 0; i < nworld; i++) {

    if ((*drain) (world[i].gps_node, TRRUNTIME, world[i].gps_pid,
		  fd) < 0)
      return (LAMERROR);
  }

  return (0);
}
