/* Speex Xmms plugin
 * (c) Jens Burkal, license: GPL
 */

#ifndef __SPEEXUTIL_H__
#define __SPEEXUTIL_H__

#include <speex_header.h>

typedef struct
{
	int vendor_length;
	char* vendor;

	int comment_num;
	char **comments;

	int icount;

} speex_comment_t;


extern int speex_seek(FILE* spxfile, int time, char direction, int freq);
extern int speex_file_info(char* filename, SpeexHeader** header, speex_comment_t* comment, int* length);

// Comments
extern int speex_comment_init(char *packet, int len, speex_comment_t* comment);
extern void speex_comment_free(speex_comment_t*);

extern char* speex_comment_get_vendor(speex_comment_t*);
extern int speex_comment_get_count(speex_comment_t*);

// Standard iterator pattern
extern void speex_comment_first(speex_comment_t*);
extern char* speex_comment_get_next(speex_comment_t*);
extern int speex_comment_isdone(speex_comment_t*);

// Get specific comment
extern char* speex_comment_get(char* comment, speex_comment_t*);


#endif
