
#include "FileSysIDList.h"

#include "GeneralFileSys.h"
#include "XLongList.h"
#include "EgOSUtils.h"

FileSysIDList::FileSysIDList() :
	AbstractStrList( ASA_OrderNotImportant, sNameComparitor ) {

}

void FileSysIDList::Assign( GeneralFileSys* inFileSys, const XLongList& inIDs, long inFlags ) {

	const UtilStr* name;
	FileObj itemID;

	RemoveAll();

	// Go thru and add an item for every item ID in the given list
	for ( int i = 1; inIDs.Fetch( i, (long*) &itemID ); i++ ) {

		name = inFileSys -> GetName( itemID );
		Add( name, itemID, inFlags );
	}

	// Perform the ordered sorting
	if ( inFlags & FILE_SYS_SORT_CI )
		SetListOrdering( ASA_Sorted_Case_Insensitive );
	else if ( inFlags & FILE_SYS_SORT_CS )
		SetListOrdering( ASA_Sorted_Case_Sensitive );
}

void FileSysIDList::Add( const UtilStr* inName, FileObj inID, long inFlags ) {

	FileSysItemInfo* item;

	if ( inName ) {
		item = new FileSysItemInfo;
		if ( inFlags & FILE_SYS_STRIP_EXTNS )
			EgOSUtils::FindExtension( *inName, &item -> mName, nil );
		else
			item -> mName.Assign( inName );
		item -> mFileID = inID;
		mItems.Add( item );
	}
}

void FileSysIDList::RemoveItem( const UtilStr* inName, bool inCaseSensitive ) {

	long i = FindString( inName, inCaseSensitive );

	Remove( i );
}

FileSysIDList::~FileSysIDList() {

	RemoveAll();
}

FileObj	FileSysIDList::FindID( const UtilStr* inStr, bool inCaseSensitive ) const {

	long i = FindString( inStr, inCaseSensitive );

	if ( i > 0 )
		return ( (FileSysItemInfo*) mItems.Fetch( i ) ) -> mFileID;
	else
		return FILE_SYS_INVALID_ID;
}

FileObj	FileSysIDList::FindID( const char* inStr, bool inCaseSensitive ) const {

	long i = FindString( inStr, inCaseSensitive );

	if ( i > 0 )
		return ( (FileSysItemInfo*) mItems.Fetch( i ) ) -> mFileID;
	else
		return FILE_SYS_INVALID_ID;
}

const UtilStr* FileSysIDList::Fetch( long inIndex ) const {

	FileSysItemInfo* item = (FileSysItemInfo*) mItems.Fetch( inIndex );

	if ( item )
		return &(item -> mName);
	else
		return nil;
}

FileObj FileSysIDList::FetchID( long inIndex ) const {

	FileSysItemInfo* item = (FileSysItemInfo*) mItems.Fetch( inIndex );

	if ( item )
		return item -> mFileID;
	else
		return FILE_SYS_INVALID_ID;
}

int FileSysIDList::sNameComparitor( const void* inA, const void* inB, const void* inThis ) {

	const FileSysItemInfo* a, *b;

	a = ( (FileSysItemInfo*) inA );
	b = ( (FileSysItemInfo*) inB );

	bool caseSensitive = ((FileSysIDList*) inThis) -> mStrOrdering == ASA_Sorted_Case_Sensitive;

	if ( a && b )
		return a -> mName.compareTo( &b -> mName, caseSensitive );
	else
		return 0;
}
