/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2003 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef __SINGIT_CONFIG_GEN_H__
#define __SINGIT_CONFIG_GEN_H__

#include <gtk/gtkobject.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define TYPE_SINGIT_CONFIG_GEN            (singit_config_gen_get_type ())
#define SINGIT_CONFIG_GEN(obj)            (GTK_CHECK_CAST ((obj), TYPE_SINGIT_CONFIG_GEN, SingitConfigGen))
#define SINGIT_CONFIG_GEN_CLASS(klass)    (GTK_CHECK_CLASS_CAST ((klass), TYPE_SINGIT_CONFIG_GEN, SingitConfigGen))
#define IS_SINGIT_CONFIG_GEN(obj)         (GTK_CHECK_TYPE ((obj), TYPE_SINGIT_CONFIG_GEN))
#define IS_SINGIT_CONFIG_GEN_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), TYPE_SINGIT_CONFIG_GEN))

typedef struct _SingitConfigGen       SingitConfigGen;
typedef struct _SingitConfigGenClass  SingitConfigGenClass;

typedef enum _SCGStatus {

	SCGS_OK,
	SCGS_DIR_FAIL,
	SCGS_FILE_FAIL,
	SCGS_NO_CFG,
	SCGS_NO_DATA,
	SCGS_NO_OBJECT,
	SCGS_PARAM_INVALID,
}
SCGStatus;

// Create new types to make the use of all the untyped pointers more clear
typedef gpointer   SCGData;
typedef gpointer   SCGFile;

struct _SingitConfigGen
{
	GtkObject   object;

	gchar      *filename;

	SCGFile     config_file;
	SCGData     config_data;

	gboolean    create_new;

	GSList     *properties;

	SCGStatus   error_code;
};

struct _SingitConfigGenClass
{
	GtkObjectClass parent_class;

	SCGData (* init_data)  (SingitConfigGen *scg);
	void    (* free_data)  (SingitConfigGen *scg, SCGData data);
	SCGFile (* open)       (SingitConfigGen *scg, const gchar* filename);
	void    (* close)      (SingitConfigGen *scg, SCGFile file, const gchar* filename);
	void    (* load)       (SingitConfigGen *scg, SCGFile file, SCGData data);
	void    (* save)       (SingitConfigGen *scg, SCGFile file, SCGData data);
	void    (* save_part)  (SingitConfigGen *scg, SCGFile file, SCGData data, gint part);
	void    (* sync)       (SingitConfigGen *scg, SCGData sync_data);
	void    (* update)     (SingitConfigGen *scg);
};

GtkType           singit_config_gen_get_type          (void);
GtkObject*        singit_config_gen_new               (void);

// Normally a configuration is stored in a central variable
// This funtion "sinks" those variable and attaches it as a "weak" reference
// to the configuration object. On "destroy" this variable is set to NULL.
// Multiple calls will cause an ** CRITICAL ** warning.
void              singit_config_gen_clear_initial     (SingitConfigGen **scg_p);

SingitConfigGen*  singit_config_gen_attach            (SingitConfigGen *scg);
void              singit_config_gen_detach            (SingitConfigGen **scg_p);

void              singit_config_gen_set_filename      (SingitConfigGen *scg, const gchar *filename);
void              singit_config_gen_set_cfg_data      (SingitConfigGen *scg, const SCGData data);
void              singit_config_gen_set_create_new    (SingitConfigGen *scg, gboolean create);

void              singit_config_gen_load              (SingitConfigGen *scg);
void              singit_config_gen_save              (SingitConfigGen *scg);
void              singit_config_gen_save_part         (SingitConfigGen *scg, gint part);

gpointer          singit_config_gen_get_data          (SingitConfigGen *scg);

SCGStatus         singit_config_gen_emit_update       (SingitConfigGen *scg);

SCGStatus         singit_config_gen_get_error_code    (SingitConfigGen *scg);
SCGStatus         singit_config_gen_set_error_code    (SingitConfigGen *scg, SCGStatus error);
void              singit_config_gen_clear_error_code  (SingitConfigGen *scg);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif  // __SINGIT_CONFIG_GEN_H__
