
#ifndef __WC_WAVE_SHAPE_H__
#define __WC_WAVE_SHAPE_H__


#include "ArgList.h"
#include "Expression.h"
#include "ExprArray.h"

#if EG_MAC
#include <QuickDraw.h>
#endif


/* This is all rediculously undocumented, so email me if u have questions. */

class WC_WaveShape  {

	public:
						WC_WaveShape();

		void			Assign( const ArgList& inArgs, ExpressionDict& ioDict );


		void			SetScaleToFit( long inWidth, long inHeight );

		void			SetupTransition( WC_WaveShape* inDest, float* inC1, float* inC2 );

		void			EvalCamera();

		void			SetupFrame( WC_WaveShape* inDest, float inW, long inNum_FFT_Bins );


		float			mSampleDuration, mSampleDurationOrig;
		int				mNumBlurs, mNumBlursOrig;
		int				mBlurVal, mBlurValOrig;
		float			mXYScale, mConfigScale, mXYScaleOrig;
		float			mPerspectiveInt, mPerspectiveIntOrig;
		bool			mConnectBins, mConnectBinsOrig;
		bool			mConnectSamples, mConnectSamplesOrig;
		bool			mConnectFirstLast, mConnectFirstLastOrig;
		bool			mCanIncreaseScale;
		float			mPrefWidth, mPrefHeight;


		Expression		mCamX, mCamY, mCamZ;
		Expression		mCamLX, mCamLY, mCamLZ;
		Expression		mCamUpX, mCamUpY, mCamUpZ;
		Expression		mLineWidth;
		bool			mX_Dep_S, mY_Dep_S, mZ_Dep_S;
		bool			mR_Dep_S, mG_Dep_S, mB_Dep_S;

		Expression		mX, mY, mZ;
		Expression		mR, mG, mB;
		ExprArray		mD_Var, mC_Var, mB_Var, mA_Var;
		Expression		mLvlR, mLvlG, mLvlB;
		Expression		mBackR, mBackG, mBackB;

		long			mNum_S_Steps, mNum_S_StepsOrig;

	protected:

};

#endif // __WC_WAVE_SHAPE_H__
