
#ifndef __MIRRORED_FILE_SYS_H__
#define __MIRRORED_FILE_SYS_H__

#include "MemFileSys.h"

#include "CEgFileSpec.h"
#include "CEgIFile.h"

#define FILE_SYS_ALL_DEPTHS		0x7FFFFFFF

class MirroredFileSys : public GeneralFileSys {

public:
	MirroredFileSys();

	// This fcn associates subsequent file accesses to a dir on this OS disk -- call is ASAP
	void					SetRootDir( CEgFileSpec& inFolder );
	void					SetRootDir( const char* inFolder );

	// See GeneralFileSys.h for the descriptions of all the fcns
	virtual FileResult			Catalog( FileObj inID, XLongList& outList );
	virtual FileResult			GetItemID( FileObj inParentID, const UtilStr& inTitle, FileObj& outID );
	virtual long				GetInfo( FileObj inID, long inParamID, FileResult* outRes = NULL )	{ return mCache.GetInfo( inID, inParamID, outRes );				}
	virtual FileResult			SetInfo( FileObj, long, long )										{ return ThrowUnimp();							}
	virtual FileResult			SetName( FileObj, const UtilStr& )									{ return ThrowUnimp();							}
	virtual const UtilStr*		GetName( FileObj inID )												{ return mCache.GetName( inID );				}
	virtual FileResult			WriteData( FileObj inID, void* inData, long inNumBytes );
	virtual FileResult			Read( FileObj inID, UtilStr& outBuf );
	virtual FileResult			Create( FileObj inParent, const UtilStr& inName, FileObj& outID, long inFlags );
	virtual FileResult			Delete( FileObj )													{ return ThrowUnimp();							}
	virtual FileResult			DeleteContents( FileObj )											{ return ThrowUnimp();							}
	virtual FileResult			GetParent( FileObj inID, FileObj& outParent )						{ return mCache.GetParent( inID, outParent );	}
	virtual FileResult			Move( FileObj, FileObj, bool )										{ return ThrowUnimp();							}

	const UtilStr*				Read( FileObj inObject );

	// Caches the given item to memory to avoid disk access at a later time.
	// InNumSubLevels is how many sub folders will also be completely cached.  0 means just the given item, 1 means
	// the given item and the items directly inside it, 2 a level deeper, and so on.   Use FILE_SYS_ALL_DEPTHS to signify
	// you want even the deepest items cached.  If an item's data block is larger than inMaxSize, it will not be cached.
	// 	Note:  Cache() maw call EgOSUtils::SpinCursor() if the caching takes a while so if you care about asthetics, consider calling ResetCursor() when you're done caching
	void					Cache( FileObj inID, long inNumSubLevels, long inMaxSize = 2000000 );

	void					PurgeCached( FileObj inID, long inNumSubLevels );

	// Turns a FileObj into an OS file spec.
	// Returns: item flags (since all items have one flag or another, 0 returned means FNF)
	// Only use this fcn for files that have to be uniquely accessed and you will not access through
	// this MirroredFileSys. Otherwise, the file will become desyncronized
	// if this MirroredFileSys caches it and you modify it later on (thru the OS).
	long					FileObjToSpec( FileObj inID, CEgFileSpec& outSpec );

protected:
	MemFileSys				mCache;
	CEgFileSpec				mRootFolder;
	UtilStr					mTemp;
	CEgIFile 				mTempFile;

	// Adds all items from the OS folder to the given cache folder.
	// Post: if 0 is returned, this file sys has the appropriate error thrown
	FileResult				ScanFolder( FileObj inID, XLongList* outList );

	void					UpdateDir( FileObj inParent, CEgFileSpec& inFolder );
};

#endif // __MIRRORED_FILE_SYS_H__
