/*
 * GtkGLMaterialDialog
 * Copyright (C) 1999,2000  Rune Lillesveen
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __GTK_GL_MATERIAL_DIALOG_H__
#define __GTK_GL_MATERIAL_DIALOG_H__

#include <gtk/gtkdialog.h>
#include "gtkglarea.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define GTK_TYPE_GL_MATERIAL_DIALOG         (gtk_gl_material_dialog_get_type())
#define GTK_GL_MATERIAL_DIALOG(obj)         (GTK_CHECK_CAST ((obj), GTK_TYPE_GL_MATERIAL_DIALOG, GtkGLMaterialDialog))
#define GTK_GL_MATERIAL_DIALOG_CLASS(klass) (GTK_CHECK_CLASS_CAST (klass, GTK_TYPE_GL_MATERIAL_DIALOG, GtkGLMaterialDialogClass))
#define GTK_IS_GL_MATERIAL_DIALOG(obj)      (GTK_CHECK_TYPE ((obj), GTK_TYPE_GL_MATERIAL_DIALOG))

typedef struct _GtkGLMaterial            GtkGLMaterial;
typedef struct _GtkGLMaterialDialog      GtkGLMaterialDialog;
typedef struct _GtkGLMaterialDialogClass GtkGLMaterialDialogClass;

typedef enum {
  PROPERTY_NONE,
  PROPERTY_AMBIENT,
  PROPERTY_DIFFUSE,
  PROPERTY_SPECULAR,
  PROPERTY_EMISSION,
  PROPERTY_SHININESS
} GtkGLMaterialProperty;

struct _GtkGLMaterial {
  gfloat ambient[4]; /* Ambient color */
  gfloat diffuse[4]; /* Diffuse color */
  gfloat specular[4]; /* Specular color */
  gfloat emission[4]; /* Emissive color */
  gfloat shininess; /* Specular exponent */
};

struct _GtkGLMaterialDialog {
  GtkWindow window;

  GtkWidget *gl_sphere_area; /* GtkGLArea drawing area for drawing lit sphere with selected material */
  GtkWidget *ok_button; /* pointer to the OK button of the dialog */
  GtkWidget *cancel_button; /* pointer to the Cancel button of the dialog */

  GtkWidget *ka_draw_area; /* drawing area for drawing ambient color inside ambient button */
  GtkWidget *kd_draw_area; /* drawing area forstatic gint on_shine_changed(GtkWidget *widget, gpointer data)
 drawing diffuse color inside diffuse button */
  GtkWidget *ks_draw_area; /* drawing area for drawing specular color inside specular button */
  GtkWidget *ke_draw_area; /* drawing area for drawing emissive color inside emission button */

  GtkWidget *color_dialog; /* gtk_color_selection_dialog */

  GtkGLMaterial material; /* the current material values */

  GtkGLMaterial old_colors; /* here we store the current colors when opening a new colorsel dialog */

  GtkGLMaterialProperty prop_cur; /* current color property which is edited */
};

struct _GtkGLMaterialDialogClass {
  GtkWindowClass parent_class;
  void (*material_changed) (GtkGLMaterialDialog *dlg);
};

GtkType gtk_gl_material_dialog_get_type(void);
GtkWidget *gtk_gl_material_dialog_new(const gchar *title);
void gtk_gl_material_dialog_set_material(GtkGLMaterialDialog *gl_mat_dlg, GtkGLMaterial *mat);
void gtk_gl_material_dialog_get_material(GtkGLMaterialDialog *gl_mat_dlg, GtkGLMaterial *mat);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __GTK_GL_MATERIAL_DIALOG_H__ */
