/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2002 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef __SINGIT_CONFIG_GEN_H__
#define __SINGIT_CONFIG_GEN_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include <gtk/gtkobject.h>
#include "singit_song.h"

#define TYPE_SINGIT_CONFIG_GEN            (singit_config_gen_get_type ())
#define SINGIT_CONFIG_GEN(obj)            (GTK_CHECK_CAST ((obj), TYPE_SINGIT_CONFIG_GEN, SingitConfigGen))
#define SINGIT_CONFIG_GEN_CLASS(klass)    (GTK_CHECK_CLASS_CAST ((klass), TYPE_SINGIT_CONFIG_GEN, SingitConfigGen))
#define IS_SINGIT_CONFIG_GEN(obj)         (GTK_CHECK_TYPE ((obj), TYPE_SINGIT_CONFIG_GEN))
#define IS_SINGIT_CONFIG_GEN_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), TYPE_SINGIT_CONFIG_GEN))

typedef struct _SingitConfigGen       SingitConfigGen;
typedef struct _SingitConfigGenClass  SingitConfigGenClass;

struct _SingitConfigGen
{
	GtkObject    object;

	ConfigFile  *config_file;
	gpointer    *config_data;
};

struct _SingitConfigGenClass
{
	GtkObjectClass parent_class;

	gpointer (* init)       (SingitConfigGen *scg);
	void     (* free)       (SingitConfigGen *scg, gpointer cfg_data);
	void     (* load)       (SingitConfigGen *scg, ConfigFile* cfg_file, gpointer cfg_data);
	void     (* save)       (SingitConfigGen *scg, ConfigFile* cfg_file, gpointer cfg_data);
	void     (* save_part)  (SingitConfigGen *scg, ConfigFile* cfg_file, gpointer cfg_data, gint part);
	void     (* update)     (SingitConfigGen *scg);
};

GtkType    singit_config_gen_get_type   (void);
GtkObject *singit_config_gen_new        (gpointer cfg_data);

gboolean singit_config_gen_attach(SingitConfigGen *scg);
void singit_config_gen_detach(SingitConfigGen *scg);

gboolean singit_config_gen_load(SingitConfigGen *scg);
gboolean singit_config_gen_save(SingitConfigGen *scg);
gboolean singit_config_gen_save_part(SingitConfigGen *scg, gint part);

gpointer singit_config_gen_get_data(SingitConfigGen *scg);

gboolean singit_config_gen_read_color(ConfigFile *cfg, gchar *section, gchar *key, gchar **color_str);

void singit_config_gen_emit_update(SingitConfigGen *scg);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif  // __SINGIT_CONFIG_GEN_H__
