/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2002 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include <glib.h>
#include <gtk/gtk.h>
#include <sys/types.h>
#include <dirent.h>
#include <sys/stat.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>

#include <xmms/configfile.h>

#include "singit_macros.h"
#include "singit_config.h"

#include "displayer_clist_config.h"

SingitConfigGen *displayer_clist_config = NULL;

extern GtkObject *singit_config;

gpointer displayer_clist_config_init_event(SingitConfigGen *scg, gpointer user_data)
{
	CListConfigData *clist_config_data = g_malloc(sizeof(CListConfigData));

	clist_config_data->forceGlobals = TRUE;
	clist_config_data->debugEnable = FALSE;

	clist_config_data->lyricFontName = NULL;
	clist_config_data->activeColor = NULL;
	clist_config_data->backgroundColor = NULL;
	clist_config_data->textColor = NULL;

	return clist_config_data;
}

void displayer_clist_config_free_event(SingitConfigGen *scg, CListConfigData *cfg_data, gpointer user_data)
{
	if (cfg_data->lyricFontName) { g_free(cfg_data->lyricFontName); }
	if (cfg_data->activeColor) { g_free(cfg_data->activeColor); }
	if (cfg_data->backgroundColor) { g_free(cfg_data->backgroundColor); }
	if (cfg_data->textColor) { g_free(cfg_data->textColor); }

	g_free(cfg_data);
}

void displayer_clist_config_load_event(SingitConfigGen *scg, ConfigFile* cfg_file, CListConfigData *cfg_data, gpointer user_data)
{
	SingitConfigData *scd = getSCD(singit_config);

	if (!xmms_cfg_read_boolean(cfg_file, "DisplayerCList", "forceGlobals", &cfg_data->forceGlobals))
		{ cfg_data->forceGlobals = TRUE; }

	if (cfg_data->forceGlobals || !xmms_cfg_read_boolean(cfg_file, "DisplayerCList", "hideIfNotFound", &cfg_data->hideIfNotFound))
		{ cfg_data->hideIfNotFound = scd->hideIfNotFound; }
	if (cfg_data->forceGlobals || !xmms_cfg_read_boolean(cfg_file, "DisplayerCList", "showJumpingBall", &cfg_data->showJumpingBall))
		{ cfg_data->showJumpingBall = scd->showJumpingBall; }
	if (cfg_data->forceGlobals || !xmms_cfg_read_boolean(cfg_file, "DisplayerCList", "guessSyncLyrics", &cfg_data->guessSyncLyrics))
		{ cfg_data->guessSyncLyrics = scd->guessSyncLyrics; }

	if (cfg_data->forceGlobals || !xmms_cfg_read_boolean(cfg_file, "DisplayerCList", "showEmpty", &cfg_data->showEmpty))
		{ cfg_data->showEmpty = scd->showEmpty; }
	if (cfg_data->forceGlobals || !xmms_cfg_read_boolean(cfg_file, "DisplayerCList", "autoResize", &cfg_data->autoResize))
		{ cfg_data->autoResize = scd->autoResize; }
#	ifdef CODEDEBUG
	if (cfg_data->forceGlobals || !xmms_cfg_read_boolean(cfg_file, "DisplayerCList", "debugEnable", &cfg_data->debugEnable))
		{ cfg_data->debugEnable = scd->debugEnable; }
#	endif

	if (cfg_data->forceGlobals || !xmms_cfg_read_string(cfg_file, "DisplayerCList", "lyricFontName", &(cfg_data->lyricFontName)))
		{ cfg_data->lyricFontName = g_strdup(scd->lyricFontName); }

	if (cfg_data->forceGlobals || !singit_config_gen_read_color(cfg_file, "DisplayerCList", "activeColor", &(cfg_data->activeColor)))
		{ cfg_data->activeColor = g_strdup(scd->activeColor); }
	if (cfg_data->forceGlobals || !singit_config_gen_read_color(cfg_file, "DisplayerCList", "backgroundColor", &(cfg_data->backgroundColor)))
		{ cfg_data->backgroundColor = g_strdup(scd->backgroundColor); }
	if (cfg_data->forceGlobals || !singit_config_gen_read_color(cfg_file, "DisplayerCList", "textColor", &(cfg_data->textColor)))
		{ cfg_data->textColor = g_strdup(scd->textColor); }

	/* global independant config */
	if (!xmms_cfg_read_boolean(cfg_file, "DisplayerCList", "showOnText", &cfg_data->showOnText))
		{ cfg_data->showOnText = TRUE; }

	if (!xmms_cfg_read_int(cfg_file, "DisplayerCList", "winPosX", &cfg_data->winPosX))
		{ cfg_data->winPosX = -1; }
	if (!xmms_cfg_read_int(cfg_file, "DisplayerCList", "winPosY", &cfg_data->winPosY))
		{ cfg_data->winPosY = -1; }
}

void write_checked_string(ConfigFile *cfg, gchar *section, gchar* entry, gchar *value)
{
	if (!value) { xmms_cfg_remove_key(cfg, section, entry); }
	else { xmms_cfg_write_string(cfg, section, entry, value); }
}

void displayer_clist_config_save_event(SingitConfigGen *scg, ConfigFile* cfg_file, CListConfigData *cfg_data, gpointer user_data)
{
	/* boolean values */
	xmms_cfg_write_boolean(cfg_file, "DisplayerCList", "forceGlobals", cfg_data->forceGlobals);
	xmms_cfg_write_boolean(cfg_file, "DisplayerCList", "hideIfNotFound", cfg_data->hideIfNotFound);
	xmms_cfg_write_boolean(cfg_file, "DisplayerCList", "showJumpingBall", cfg_data->showJumpingBall);
	xmms_cfg_write_boolean(cfg_file, "DisplayerCList", "guessSyncLyrics", cfg_data->guessSyncLyrics);
	xmms_cfg_write_boolean(cfg_file, "DisplayerCList", "showEmpty", cfg_data->showEmpty);
	xmms_cfg_write_boolean(cfg_file, "DisplayerCList", "autoResize", cfg_data->autoResize);
#	ifdef CODEDEBUG
	xmms_cfg_write_boolean(cfg_file, "DisplayerCList", "debugEnable", cfg_data->debugEnable);
#	endif

	/* string values */
	write_checked_string(cfg_file, "DisplayerCList", "lyricFontName", cfg_data->lyricFontName);
	write_checked_string(cfg_file, "DisplayerCList", "activeColor", cfg_data->activeColor);
	write_checked_string(cfg_file, "DisplayerCList", "backgroundColor", cfg_data->backgroundColor);
	write_checked_string(cfg_file, "DisplayerCList", "textColor", cfg_data->textColor);

	/* global independant config */
	xmms_cfg_write_boolean(cfg_file, "DisplayerCList", "showOnText", cfg_data->showOnText);

	xmms_cfg_write_int(cfg_file, "DisplayerCList", "winPosX", cfg_data->winPosX);
	xmms_cfg_write_int(cfg_file, "DisplayerCList", "winPosY", cfg_data->winPosY);
}

void displayer_clist_config_destroy_event(SingitConfigGen *scg, gpointer user_data)
{
	displayer_clist_config = NULL;
}

SingitConfigGen* displayer_clist_config_new(void)
{
	GtkObject *dcc;

	if (displayer_clist_config != NULL) { return displayer_clist_config; }

	dcc = singit_config_gen_new(NULL);

	gtk_signal_connect(GTK_OBJECT(dcc), "init",
		GTK_SIGNAL_FUNC(displayer_clist_config_init_event), NULL);
	gtk_signal_connect(GTK_OBJECT(dcc), "free",
		GTK_SIGNAL_FUNC(displayer_clist_config_free_event), NULL);
	gtk_signal_connect(GTK_OBJECT(dcc), "load",
		GTK_SIGNAL_FUNC(displayer_clist_config_load_event), NULL);
	gtk_signal_connect(GTK_OBJECT(dcc), "save",
		GTK_SIGNAL_FUNC(displayer_clist_config_save_event), NULL);
	gtk_signal_connect(GTK_OBJECT(dcc), "destroy",
		GTK_SIGNAL_FUNC(displayer_clist_config_destroy_event), NULL);

	return SINGIT_CONFIG_GEN(dcc);
}
