/*  XMMS - Cross-platform multimedia player
 *  Copyright (C) 1998-2000  Peter Alm, Mikael Alm, Olle Hallnas, Thomas Nilsson and 4Front Technologies
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef JACK_H
#define JACK_H

#include "config.h"

#include <gtk/gtk.h>

#include <sys/types.h>
#include <sys/ioctl.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <sys/soundcard.h>

#include <fcntl.h>
#include <unistd.h>
#include <pthread.h>

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "xmms/plugin.h"

#ifdef WORDS_BIGENDIAN
# define IS_BIG_ENDIAN TRUE
#else
# define IS_BIG_ENDIAN FALSE
#endif

extern OutputPlugin op;

typedef struct
{
	gint audio_device;
	gint mixer_device;
	gint buffer_size;
	gint prebuffer;
	gboolean use_master;
	gboolean use_alt_audio_device, use_alt_mixer_device;
	struct
	{
		int left, right;
	} vol;
	gboolean soft_volume;
	gchar *alt_audio_device, *alt_mixer_device;
}
JACKConfig;

extern JACKConfig jackxmms_cfg;

void jackxmms_init(void);
void jackxmms_about(void);
void jackxmms_configure(void);

void jackxmms_get_volume(int *l, int *r);
void jackxmms_set_volume(int l, int r);

int jackxmms_playing(void);
int jackxmms_free(void);
void jackxmms_write(void *ptr, int length);
void jackxmms_close(void);
void jackxmms_flush(int time);
void jackxmms_pause(short p);
int jackxmms_open(AFormat fmt, int rate, int nch);
int jackxmms_get_output_time(void);
int jackxmms_get_written_time(void);
void jackxmms_set_audio_params(void);

void jackxmms_free_convert_buffer(void);
int (*jackxmms_get_convert_func(int output, int input))(void **, int);
int (*jackxmms_get_stereo_convert_func(int output, int input))(void **, int, int);

#define DEV_DSP "/dev/dsp"
#define DEV_MIXER "/dev/mixer"
#define _(x) x

#endif
