/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.xmlresume.filter;

import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class FileWriterHandler
extends DefaultHandler {
    private static final int ERROR = 10;
    private static final int WARN = 5;
    private static final int DEBUG = 1;
    public int debugLevel = 9;
    private PrintWriter output;
    private Locator locator;
    private String indent;

    public void startDocument() throws SAXException {
        this.debug("Received startDocument event");
        this.output.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        this.output.println("<!DOCTYPE resume PUBLIC \"-//Sean Kelly//DTD Resume @VERSION_DOTS@//EN\" \"http://xmlresume.sourceforge.net/dtd/resume.dtd\">");
        this.output.println("<!-- THIS FILE WAS GENERATED AUTOMATICALLY BY XMLResume's Targeting Filter. -->");
        this.indent = "";
    }

    public void endDocument() throws SAXException {
        this.debug("Received endDocument event");
        this.output.println("<!-- END OF DOCUMENT -->");
        this.output.flush();
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.debug("Received startElement event:\t" + qName);
        this.output.print("<" + qName);
        int nAttr = attributes.getLength();
        int i = 0;
        while (i < nAttr) {
            this.output.print(" " + attributes.getQName(i) + "=\"" + attributes.getValue(i) + "\"");
            ++i;
        }
        this.output.print(">");
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.debug("Received endElement event:" + qName);
        this.output.print("</" + qName + ">");
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        String data = new String(ch, start, length);
        this.debug("Received characters event: " + data);
        this.output.print(data);
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.debug("Received startPrefixMapping event: prefix=" + prefix + " uri=" + uri);
    }

    public void endPrefixMapping(String prefix) {
        this.debug("Received endPrefixMapping event: prefix=" + prefix);
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        String data = new String(ch, start, length);
        this.debug("Received ignorableWhitespace event.");
        this.output.print(data);
    }

    public void setDocumentLocator(Locator l) {
        this.debug("Received setDocumentLocator event");
        this.locator = l;
    }

    public void skippedEntity(String name) throws SAXException {
        this.debug("Received skippedEntity event: " + name);
    }

    public void warning(SAXParseException e) {
        this.debug("Received warning " + e, 5);
    }

    public void fatalError(SAXParseException e) {
        this.debug("Received fatalError " + e, 10);
    }

    public void error(SAXParseException e) {
        this.debug("Received error " + e, 10);
    }

    private void debug(String msg) {
        this.debug(msg, 1);
    }

    private void debug(String msg, int severity) {
        if (severity >= this.debugLevel) {
            System.err.println(msg);
        }
    }

    public FileWriterHandler(PrintStream output) throws UnsupportedEncodingException {
        this(output, 9, "UTF-8");
    }

    public FileWriterHandler(PrintStream output, int debugLevel) throws UnsupportedEncodingException {
        this(output, debugLevel, "UTF-8");
    }

    public FileWriterHandler(PrintStream output, String enc) throws UnsupportedEncodingException {
        this(output, 9, enc);
    }

    public FileWriterHandler(PrintStream output, int debugLevel, String enc) throws UnsupportedEncodingException {
        this.debugLevel = debugLevel;
        this.output = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)output, enc)));
    }
}

