
if ($#ARGV < 0)
{
    print STDERR
	" $$: $0 @ARGV
 DESCRIPTION
  will try to replace the semantic markups found so far with markups
  as used by docbook style comments.
";
    exit;
}

sub c2x_docbook_tags
{
    $in = shift;

    # <a href>
    $in =~ s{<a href=(\"[^\"]*\"[^<>]*)>(?!</a>) ((?:.(?!</a>))*.) </a>}
    {"<ulink url=".$1.">".$2."</ulink>"}gsex;

    $in =~ s{(</?)XREF(>)} {$1."xref".$2}mgex; # xref is simply known
    $in =~ s{(</?)CSTR(>)} {$1."literal".$2}mgex;

    $in =~ s{(</?)CCHR(>)} {$1."constant".$2}mgex;
    $in =~ s{(</?)CPRE(>)} {$1."optional".$2}mgex;
    $in =~ s{(</?)CDOC(>)} {$1."comment".$2}mgex;

    $in =~ s{(</?)FCODETYPE(>)} {print STDERR "."; $1."type".$2}mgex;
    $in =~ s{(</?)FCODENAME(>)} {$1."function".$2}mgex;

# devnote..
# <literal>  inline text that is some literal value.
# <constant> a programming or sytem constant (prog langs and constructs)
# <function> <interface> <msgtext> <parameter> <property> 
# <structfield> <structname> <symbol> <token> <type> <varname>

# general purpose:  <email> <filename> <literal> <symbol> <token> <type>

    my $c = chr(12);
    $in =~ s{$c} {\n}sg;

#    $in =~ s{&amp;}  {|A|}sg;
#    $in =~ s{&lt;}   {|L|}sg;
#    $in =~ s{&gt;}   {|G|}sg;
#    $in =~ s{&quot;} {|Q|}sg;
    $in =~ s{<a [^<>]*>} {}g;
    $in =~ s{</a>} {}g;

    return $in;
}

my $T = "";
my %o;
for (@ARGV)
{
    if (/^-$/) { $T .= join ("",<STDIN>); }
    elsif (/^-([\w-]+)=(.*)/) { $o{$1} = $2; }
    elsif (/^-([\w-]+)/) { $o{$1} = ""; }
    else {
	my $F = $_; 
	if (open F, "<$F") { $T .= join("",<F>); close F; }
	else { die "could not open $F", $1; }
    }
}

if (length $T)
{ 
    my $head = "";
    my $tail = "";
    {
	$o{css} = "c2x-docbook.css" if not defined $o{css};
        $head .= "<!DOCTYPE article PUBLIC \"-//OASIS//DTD DocBook V3.1//EN\"";
	$head .= "\n ";
	$head .= "\n>\n";
	$head .= "<article>";

	my $F = $o{css};
	if (-f $F) {
	    if (open F,"<$F") {
		$head .= "<artheader>\n".join("",<F>)."\n</artheader>\n";
		close F;
	    }
	}
        $head .= "<programlisting>";
	$tail .= "</programlisting></article>";
    }


    if (not defined $o{o} and not defined $o{a}) {
	print $head,c2x_docbook_tags($T),$tail;
    }else{
	if (defined $o{o}) {
	    my $F = $o{o}; 
	    if (open F,">$F") {
		print F $head,c2x_docbook_tags($T),$tail;
		close F;
	    }
	}

	if (defined $o{a}) {
	    my $F = $o{a}; 
	    if (open F,">>$F") {
		print F $head,c2x_docbook_tags($T),$tail;
		close F;
	    }
	}
    }
}

