package xm::colontags;
use xm::o;

sub DESC {"
  look for <:tag whatever> markups and replace the sequence before
  with the one surrounded by the given tag. examples:
  \"abc\"<:em>   -> <em>abc</abc>
  \'abc\'<:em>   -> <em>abc</abc>
  http:see\@there<:em>   -> <em>http:see\@there</abc>
  see abc <:em>   -> <em> see abc </abc>     ... the complete line
"}

sub ARGS { return xm::o::args_stdin(@_, DESC); }

# look for <:tag> and expand it as a double-tag for the whole line
sub DO
{
    my $in = shift;
    my $max;

    # move at-start-of-line colontags to the end-of-line
    $max = 100; while (--$max and $in =~
    s{ ^ (\s*) <\b([\w.:-]+):> (.*) $ } 
    { 
        $1.$3." <:".$2.">".$4
    }gmex) {};

    # if there is a dbl-quoted-text just before, use only that one
    $max = 100; while (--$max and $in =~
    s{ \" ([^\"\<\>]*) \" <:\b([\w.:-]+)(>|\s*\n?[^<>]*>) } 
    { 
	"<".$2.$3.$1."</".$2.">"
    }gmex) {};

    # if there is a sgl-quoted-text just before, use only that one
    $max = 100; while (--$max and $in =~
    s{ \' ([^\'\<\>]*) \' <:\b([\w\:\-]+)(>|\s*\n?[^<>]*>) } 
    { 
	"<".$2.$3.$1."</".$2.">"
    }gmex) {};

    # and for a single word ... enough charspan given for an url...
    $max = 100; while (--$max and $in =~
    s{  \b (\w[\:\/\.\-\+\@\w]+) \b <:\b([\w\:\-]+)(>|\s*\n?[^<>]*>) } 
    { 
	"<".$2.$3.$1."</".$2.">"
    }gmex) {};

    # and finally, expand as a line tag...
    $max = 1000; while (--$max and $in =~
    s{ ^ ((?:.(?!<:\b[\w\:\-]*>))*\s) <:\b([\w\:\-]+)(>|\s*\n?[^<>]*>) } 
    { 
	"<".$2.$3.$1."</".$2.">"
    }mex) {};

    return $in;
}

1;







