.\"(c) Copyright 1992 by Panagiotis Tsirigotis
.\"All rights reserved.  The file named COPYRIGHT specifies the terms 
.\"and conditions for redistribution.
.\"
.\" $Id: xinetd.man,v 1.1.1.1 1999/10/12 17:28:59 bbraun Exp $
.TH XINETD 1L "28 April 1993"
.\" *************************** NAME *********************************
.SH NAME
xinetd \- the extended Internet services daemon
.\" *************************** SYNOPSIS *********************************
.SH SYNOPSIS
.B xinetd
[\fIoptions\fP]
.\" *************************** DESCRIPTION *********************************
.SH DESCRIPTION
\fBxinetd\fP performs the same function as \fBinetd\fP: it starts
programs that provide Internet services.  Instead of having such
servers started at system initialization time, and be dormant until a
connection request arrives, \fBxinetd\fP is the only daemon process
started and it listens on all service ports for the services listed in
its configuration file. When a request comes in, \fBxinetd\fP starts
the appropriate server.  Because of the way it operates, \fBxinetd\fP
(as well as \fBinetd\fP) is also referred to as a super-server.
.LP
The services listed in \fBxinetd\fP's configuration file can be
separated into two groups.  Services in the first group are called
.I "multi-threaded"
and they require the forking of a new server process for each new
connection request.  The new server then handles that connection.  For
such services, \fBxinetd\fP keeps listening for new requests so that it
can spawn new servers.  On the other hand, the second group includes
services for which the service daemon is responsible for handling all
new connection requests.  Such services are called
.I "single-threaded"
and \fBxinetd\fP will stop handling new requests for them until the
server dies.  Services in this group are usually datagram-based.
.LP
So far, the only reason for the existence of a super-server was to
conserve system resources by avoiding to fork a lot of processes which
might be dormant for most of their lifetime.  While fulfilling this
function, \fBxinetd\fP takes advantage of the idea of a super-server to
provide features such as access control and logging.  Furthermore,
\fBxinetd\fP is not limited to services listed in
.I /etc/services.
Therefore, anybody can use \fBxinetd\fP to start special-purpose
servers.
.\" *************************** OPTIONS *********************************
.SH OPTIONS
.TP
.BR \-d
Enables debug mode. This produces a lot of debugging output, and it
makes it possible to use a debugger on \fBxinetd\fP.
.TP
.BI \-syslog " syslog_facility"
This option enables syslog logging of \fBxinetd\fP-produced messages
using the specified syslog facility.
The following facility names are supported:
.I daemon,
.I auth,
.I user,
.I "local[0-7]"
(check \fIsyslog.conf(5)\fP for their meanings).
This option is ineffective in debug mode since all relevant messages are sent
to the terminal.
.TP
.BI \-filelog " logfile"
\fBxinetd\fP-produced messages will be placed in the specified file.
Messages are always appended to the file.
If the file does not exist, it will be created.
This option is ineffective in debug mode since all relevant messages are sent
to the terminal.
.TP
.BI \-f " config_file"
Determines the file that \fBxinetd\fP uses for configuration. The
default is \fI/etc/xinetd.conf\fP.
.TP
.BR \-pid
.br
The process ID is written to standard error.
This option is ineffective in debug mode.
.TP
.BI \-loop " rate"
This option sets the loop rate beyond which a service is considered in
error and is deactivated. The loop rate is specified in terms of
the number of servers per second that can be forked for a process.
The speed of your machine determines the correct value for this option.
The default rate is 10.
.TP
.BR \-reuse
If this option is used, \fBxinetd\fP will set the socket option
\fISO_REUSEADDR\fP before binding the service socket to an Internet
address. This allows binding of the address even if there are programs
that use it, which happens when a previous instance of \fBxinetd\fP
has started some servers that are still running.
This option has no effect on
.SM RPC
services.
.TP
.BI \-limit " proc_limit"
This option places a limit on the number of concurrently running processes
that can be started by
.B xinetd.
Its purpose is to prevent process table overflows.
.TP
.BI \-logprocs " limit"
This option places a limit on the number of concurrently running servers
for remote userid acquisition.
.TP
.BI \-shutdownprocs " limit"
This option places a limit on the number of concurrently running servers
for service shutdown (forked when the
.SB RECORD
option is used).
.TP
.BI \-cc " interval"
This option instructs
.B xinetd
to perform periodic consistency checks on its internal state every
.I interval
seconds.
.LP
The \fIsyslog\fP and \fIfilelog\fP options are mutually exclusive.
If none is specified, the default is syslog using the
.I daemon
facility.
You should not confuse \fBxinetd\fP messages with messages related to
service logging. The latter are logged only if this is specified
via the configuration file.
.\" *********************** CONTROLLING XINETD ****************************
.SH "CONTROLLING XINETD"
.LP
\fBxinetd\fP performs certain actions when it receives certain signals.
The actions associated with the specific signals can be redefined
by editing \fIconfig.h\fP and recompiling.
.TP 15
.SB SIGUSR1
causes a soft reconfiguration, which means that \fBxinetd\fP rereads
the configuration file and adjusts accordingly.
.TP
.SB SIGUSR2
causes a hard reconfiguration, which is the same as a soft reconfiguration
except that servers for services that are no longer available are
terminated. Access control is performed again on running servers
by checking the remote location, access times and server instances.
If the number of server instances is lowered, some arbitrarily picked
servers will be killed
to satisfy the limit; this will happen \fIafter\fP any servers are
terminated because of failing the remote location or access time checks.
Also, if the
.SB INTERCEPT
flag was clear and is set, any running servers for that service will
be terminated;
\fIthe purpose of this is to ensure that after a hard reconfiguration
there will be no running servers that can accept packets from addresses
that do not meet the access control criteria\fP.
.TP
.SB SIGQUIT
causes program termination.
.TP
.SB SIGTERM
terminates all running servers before terminating \fBxinetd\fP.
.TP
.SB SIGHUP
causes an internal state dump (the default dump file is
\fI/tmp/xinetd.dump\fP;
to change the filename, edit \fIconfig.h\fP and recompile).
.TP
.SB SIGIOT
causes an internal consistency check to verify that the data structures
used by the program have not been corrupted.
When the check is completed
.B xinetd
will generate a message that says if the check was successful or not.
.LP
On reconfiguration the log files are closed and reopened. This allows
removal of old log files.
.\" *********************** FILES ****************************
.SH FILES
.LP
.PD .1v
.TP 20
.SB /etc/xinetd.conf
default configuration file
.TP
.SB /var/run/xinetd.dump
default dump file
.PD
.\" *********************** SEE ALSO ****************************
.SH "SEE ALSO"
.I "inetd(8),"
.LP
.I "xinetd.conf(5),"
.LP
.I "xinetd.log(5)"
.\" *********************** AUTHOR ****************************
.SH AUTHOR
Panos Tsirigotis, CS Dept, University of Colorado, Boulder
.\" *********************** PRONUNCIATION ****************************
.SH PRONUNCIATION
zy-net-d

