// text.h -- subclass of Drawable for text/labels

#ifndef TEXT_H
#define TEXT_H

#include <qobject.h>
#include <qrect.h>
#include <qfont.h>
#include "render2d.h"
#include "drawable.h"
#include "dpoint.h"

class Molecule;

class Text : public Drawable {
  Q_OBJECT
    public:
  Text(Render2D *, QObject *parent = 0, const char *name = 0);
  void Render();  // draw this object
  void EditRender();  // draw this object, with cursor and highlight box
  int Type();  // return type of object
  bool Find(DPoint *); // does this Bond contain this DPoint?
  DPoint * FindNearestPoint(DPoint *, double &);
  Drawable * FindNearestObject(DPoint *, double &);
  void setPoint(DPoint *);
  int Justify() { return justify; }
  void setJustify(int a) { justify = a; }
  bool WithinBounds(DPoint *);
  bool WithinRect(QRect, bool);
  void InsertCharacter(QKeyEvent *);
  QPoint GetTopLeftPoint(void);  // get real top left point, based on justify
  QPoint NearestCenter(QPoint, int, int &);
  void setText(QString nt) { text = nt; }
  QString getText() { return text; } // not just Text()!
  void setTextMask(QString nm) { textmask = nm; }
  QString getTextMask() { return textmask; }
  void setFont(QFont f) { 
    font = f; 
    bfont = f;
    bfont.setWeight(QFont::Bold);
    ifont = f;
    ifont.setItalic(true);
    ufont = f;
    ufont.setUnderline(true);
  }
  void setMolecule(Molecule *m1) { molecule = m1; }
  Molecule *getMolecule() { return molecule; }
  void setDataType(int d1) { DataType = d1; }
  int getDataType() { return DataType; }
  QFont getFont() { return font; }
  void MoveCursor(DPoint *);
  void Select(DPoint *, DPoint *);
  QRect BoundingBox();
  void DoSuperscript();
  void DoSubscript();
  void DoBold();
  void DoItalic();
  void DoUnderline();
  void DeselectAllText() { selectMin = -1; selectMax = -1; }
  // set text parsed from XML file
  void SetTextFromXML(QString) { }
  QString ToXML(QString);
  QString ToCDXML(QString);
  void FromXML(QString);
  void SetFontFromXML(QString);
  void SetTextstringFromXML(QString);
  void SetTextmaskFromXML(QString);
 private:
  // Renderer
  Render2D *r;
  // Text this object holds
  QString text;
  // Text modifier -- super/subscript flags
  QString textmask;
  // Text font(s) - regular, bold, italic, underline
  QFont font, bfont, ifont, ufont;
  // justify -- how/where to draw this text
  int justify;
  // dimensions of text box
  QRect BBox;
  // cursor position (character # within text)
  int cursor;
  // selection range
  int selectMin, selectMax;
  // is the Shift key down?
  bool shiftdown;
  // Molecule this text gets data from
  Molecule *molecule;
  int DataType;
};

#endif
