#include <iostream.h>
#include <qobject.h>
#include <qlist.h>
#include <qstring.h>

#include "drawable.h"
#include "clipboard.h"
#include "molecule.h"
#include "bond.h"
#include "arrow.h"
#include "bracket.h"
#include "text.h"
#include "chemdata.h"
#include "defs.h"

void ChemData::Cut() {
  Copy();
  EraseSelected();
}

void ChemData::Copy() {
  QList<Drawable> unique;
  Drawable *td2;

  for (tmp_draw = drawlist.first(); tmp_draw != NULL; 
       tmp_draw = drawlist.next()) {
    if (tmp_draw->Type() != TYPE_MOLECULE) {
      // Copy to clipboard if selected
      if (tmp_draw->Highlighted() == true)
	clip->objects.append(tmp_draw);
    } else {
      // Get list of objects, then copy to clipboard if selected
      unique = tmp_draw->AllObjects();
      for (td2 = unique.first(); td2 != NULL; td2 = unique.next() ) {
	if (td2->Highlighted() == true)
	  clip->objects.append(td2);
      }
    }
  }  
}

bool ChemData::Paste() {
  DeselectAll();
  QList<DPoint> oldPoints;
  QList<DPoint> newPoints;
  DPoint *n;
  Bond *b;
  Text *ot, *t;

  // need to deep copy stuff coming off the Clipboard
  // first, find all unique DPoint's
  for (tmp_draw = clip->objects.first(); tmp_draw != NULL;
       tmp_draw = clip->objects.next() ) {
    if (oldPoints.contains(tmp_draw->Start()) == 0)
      oldPoints.append(tmp_draw->Start());
    if (tmp_draw->End() != 0) {
      if (oldPoints.contains(tmp_draw->End()) == 0)
	oldPoints.append(tmp_draw->End());
    }
  }
  cout << oldPoints.count() << endl;
  if (oldPoints.count() == 0) return false;

  // make new DPoint's which correspond to old DPoint's
  for (tmp_pt = oldPoints.first(); tmp_pt != NULL; tmp_pt = oldPoints.next() ){
    n = new DPoint;
    n->x = tmp_pt->x;
    n->y = tmp_pt->y;
    n->id = tmp_pt->id;
    n->element = tmp_pt->element;
    newPoints.append(n);
  }
  // now add all non-TYPE_TEXT objects back to current
  for (tmp_draw = clip->objects.first(); tmp_draw != NULL;
       tmp_draw = clip->objects.next() ) {
    if (tmp_draw->Type() == TYPE_ARROW) {
      addArrow(newPoints.at(oldPoints.find(tmp_draw->Start())), 
	       newPoints.at(oldPoints.find(tmp_draw->End())), 
	       tmp_draw->GetColor(), 
	       true);
    }
    if (tmp_draw->Type() == TYPE_BRACKET) {
      Bracket *tmp_bracket = (Bracket *)tmp_draw;
      addBracket(newPoints.at(oldPoints.find(tmp_draw->Start())), 
		 newPoints.at(oldPoints.find(tmp_draw->End())), 
		 tmp_draw->GetColor(), 
		 tmp_bracket->Style(),
		 true);
    }
    if (tmp_draw->Type() == TYPE_BOND) {
      b = (Bond *)tmp_draw;
      addBond(newPoints.at(oldPoints.find(tmp_draw->Start())), 
	      newPoints.at(oldPoints.find(tmp_draw->End())), 
	      b->Thick(), b->Order(),
	      tmp_draw->GetColor(), 
	      true);
    }
  }
  //add all TYPE_TEXT objects (ensures bonds and molecules exist before labels)
  for (tmp_draw = clip->objects.first(); tmp_draw != NULL;
       tmp_draw = clip->objects.next() ) {
    if (tmp_draw->Type() == TYPE_TEXT) {
      ot = (Text *)tmp_draw;
      t = new Text(r);
      t->setPoint(newPoints.at(oldPoints.find(tmp_draw->Start())));
      t->setText(ot->getText());
      t->setTextMask(ot->getTextMask());
      t->SetColor(ot->GetColor());
      t->setFont(ot->getFont());
      t->setJustify(ot->Justify());
      t->Highlight(true);
      addText(t);
    }
  }
  return true;
}

void ChemData::StartUndo(int fn, DPoint *s1) {
  //cout << "Saved undo file" << endl;
  // checkpoint!
  save_native("");
  //cout << "File length: " << current_undo_file.length() << endl;
  last_states.append(current_undo_file);
  if (last_states.count() > 16)
    last_states.remove(last_states.begin());
}

bool ChemData::Undo() {
  if (last_states.count() == 0) {
    return false;
  }
  current_undo_file = last_states[last_states.count() - 1];
  last_states.remove(last_states.at(last_states.count() - 1));
  load_native(current_undo_file);
  return true;
}
