#!/usr/bin/perl -w
#
# Package: Xdebconfigurator
# This is a script that takes a Graphics Card Name as input
# and returns the driver-name to use, as stated in Xconfigurators Cards-table.
# The table looks something like this:
#  	NAME Generic VGA compatible
#  	CHIPSET Generic VGA
#  	SERVER VGA16
#   	DRIVER vga
# or
#		NAME ATI Radeon AGP
#		SEE ATI Radeon (generic)
# which means it uses same DRIVER etc as ATI Radeon (generic)
#
# Warning: there's no limit on words in card-name so alotta words can cause
# this script to go on for ages!

# package hwdata contains XConfigurator's map "Cards"
$HOME = "/usr/share/hwdata";

# path to Cards-table
$CARDS = "$HOME/Cards";

$LOCK_EX = 2; $LOCK_UN = 8; 
%cardhash = ();
$driver = "";

if ($#ARGV < 0) {
    print "Syntax: Xdriver.pl [Card Name]\n";
    #die "Syntax: Xdriver.pl [Card Name]";
} elsif ($#ARGV == 0) {
    print "Getting driver for card: $ARGV[0]\n";
    $CARDNAME = "$ARGV[0]";
}
# end if
$CARDNAME =~ s/\//_/ig;

open (FIL, "<$CARDS") or die "Uhoh.. can't read from $CARDS\n";
flock(FIL, $LOCK_EX);
seek(FIL, 0, 0);
$get_driver = 0;#get name first
while (<FIL>) {
    # make a hash of (cardname->driver)
    chop $_;
    if(!$get_driver && $_ =~ /^NAME ([\w| |\/|\+]+)/) {
	$hkey = "\L$1"; #to lowercase
	$hkey =~ s/([\w|\d| |\+|\/]+) \(.+\)/$1/i;
	$hkey =~ s/ $//;#remove trailing space
	    $get_driver = 1; #got name, get driver
    } elsif($get_driver && $_ =~ /^SEE ([\w| |\/|\+]+)/) {		
	$hval = "\L$1"; #to lowercase
	$hval =~ s/([\w|\d| |\+|\/]+) \(.+\)/$1/i;
	$hval = "SEE $hval";
    } elsif($get_driver && $_ =~ /^DRIVER ([\w| |\/|\+]+)/) {
	$hval = $1;
    } elsif($_ eq "" || $_ eq " ") {
	#empty line.. start over
	$hkey = "";
	$hval = "";
	$get_driver = 0;
    }
	
    if($hkey && $hval) {
	#it seems the hash-keys can't include certain characters (/ for one)
	$hval =~ s/\//_/ig;
	$hkey =~ s/\//_/ig;
	#print "$hkey $hval\n";
	#we got a pair, add it to the hash
	$cardhash{$hkey} = $hval;
	$hkey = "";
	$hval = "";
	# sometimes there's both a DRIVER and a SEE
	$get_driver = 0;
    }
}
flock(FIL, $LOCK_UN);
close (FIL);

if( $cardhash{"\L$CARDNAME"} ) {
    $driver = $cardhash{"\L$CARDNAME"}; #all keys are lowercase
}

# most names are not written the way they are reported by i.e. /proc/pci
# ex: NAME NVIDIA GeForce 2 MX (generic) -> /proc/pci: nVidia Corporation NV11 (GeForce2 MX)

#try splitting name?
if(!$driver) {
    #this might slow down the process, but WILL catch GeForce2 as GeForce 2
    #$CARDNAME =~ s/(([a-zA-Z]+)(\d{1}))/$1 $2 $3/ig; 
    $CARDNAME =~ s/(GeForce)(\d)/$1 $2/ig;
    #I've substed / with _ in the hash and card names
    $CARDNAME =~ s/(ViRGE_)(MX)(.+)/$1$2/ig; #S3 ViRGE/MX can be reported as S3 Inc. ViRGE/MX+MV 
    #print "$CARDNAME\n";
    if( $cardhash{"\L$CARDNAME"}) {
	$driver = $cardhash{"\L$CARDNAME"}; #all keys are lowercase
	print "$CARDNAME\n";
    }
}

if(!$driver) {
    #split into words and retry
    # TODO: we might want to limit the number of words, lest this process
    #       might take forever
    #$tmp="";
    @word = split / /, $CARDNAME;
		
    $continue = 1;
    $flag = 0;
    for(1..$#word) {push @i, 0}; #create an array of numbers (index)

    while ($continue && !$driver) {
	$streng = "";
	for ($letter=0; $letter<@i;$letter++) {
	    if(!($streng =~ /$word[$i[$letter]]/i) ) { 
		$streng .= $word[$i[$letter]];  
		if( $cardhash{"\L$streng"} ) {
		    $driver = $cardhash{"\L$streng"};# 
			print "$streng\n";
		}	
		$streng .= " ";
	    }
	    #print "$streng\n";
	}
	
	for($inc=0; $inc<@i; $inc++) {
	    if($flag==0) {
		$i[$inc]++;
		
		if ($i[$inc] > (@word-1)) {
		    $i[$inc] = 0;
		} else {
		    $flag = 1;
		}
	    }
	}
	if ($flag == 0) {$continue = 0};
	$flag = 0;
    }
}

if(!$driver) {
    $driver = "unknown";	
}

while($driver && $driver =~ /^SEE (.+)/) {
    $driver = $cardhash{"\L$1"}; #lookup card 
}

print "$driver \n";
