/*
  XBubble - utils.c

  Copyright (C) 2002  Ivan Djelic <ivan@savannah.gnu.org>
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#include "utils.h"

void * xmalloc (size_t size) {
  void *value = malloc (size);
  if ( value == NULL ) {
    perror("xmalloc");
    exit(1);
  }
  return value;
}

void * xrealloc ( void *p, size_t size) {
  void *value = realloc ( p, size);
  if ( value == NULL ) {
    perror("xrealloc");
    exit(1);
  }
  return value;
}

int rnd( int range ) {
  int x =  (int) floor( 1.0*range*rand()/(RAND_MAX + 1.0));
  /* return ( x % range ) just in case rand() is broken */
  return ( x % range );
}

Set new_set( int max_size ) {
  Set s = (Set) xmalloc( sizeof( struct _Set ));
  s->element = (void **) xmalloc( sizeof(void *) * max_size);
  s->max_size = max_size;
  s->size = 0;
  return s;
}

void delete_set( Set s ) {
  free(s->element);
  free(s);
}

#define SET_BLOCK (20)

void add_element_to_set( Set s, void * p ) {
  if ( s->size >= s->max_size ) {
    s->max_size += SET_BLOCK;
    s->element = (void **) xrealloc( s->element, sizeof(void *)*s->max_size );
  }
  s->element[s->size++] = p;
}

void remove_element_from_set( Set s, void * p ) {
  int i;
  for ( i = 0; i < s->size; i++ )
    if ( s->element[i] == p ) {
      s->element[i] = s->element[--s->size];
      break;
    }
}

void remove_element_from_set_at( Set s, int i ) {
  if ( i < s->size )
    s->element[i] = s->element[--s->size];
}

void empty_set( Set s ) {
  s->size = 0;
}

Vector new_vector( int max_size ) {
  Vector v = (Vector) xmalloc( sizeof( struct _Vector ));
  v->element = (int *) xmalloc( sizeof(int) * max_size);
  v->max_size = max_size;
  v->size = 0;
  return v;
}

void delete_vector( Vector v ) {
  free(v->element);
  free(v);
}

void add_element_to_vector( Vector v, int p ) {
  if ( v->size >= v->max_size ) {
    v->max_size += SET_BLOCK;
    v->element = (int *) xrealloc( v->element, sizeof(int)*v->max_size );
  }
  v->element[v->size++] = p;
}

int element_is_in_vector( Vector v, int p ) {
  int i;
  for ( i = 0; i < v->size; i++ )
    if ( v->element[i] == p )
      return 1;
  return 0;
}

void empty_vector( Vector v ) {
  v->size = 0;
}
