#ifndef _BUBBLE_H
#define _BUBBLE_H

#include "sprite.h"

enum BubbleState { 
  NEW = 0,
  READY,
  LAUNCHED, 
  STUCK, 
  EXPLODING, 
  FALLING, 
  RISING,
  RUNAWAY,
  DEAD
};

#define NB_BUBBLE_STATES (DEAD+1)

struct _Bubble {
  enum BubbleState state;
  int color, clock, cell;
  double x, y, vx, vy, target_y;
  Sprite sprite;
};
typedef struct _Bubble * Bubble;

Bubble new_bubble( int color, double x, double y, int layer );
void delete_bubble( Bubble bubble );
void set_bubble_state( Bubble bubble,enum BubbleState state, int layer, int c);
void set_bubble_position( Bubble bubble, double x, double y );

#endif /* _BUBBLE_H */

