/*
 * $Id: gps.c,v 1.10 2001/05/01 14:33:43 kg4ijb Exp $
 *
 * XASTIR, Amateur Station Tracking and Information Reporting
 * Copyright (C) 1999,2000  Frank Giannandrea
 * Copyright (C) 2000,2001  The Xastir Group
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Look at the README for more information on the program.
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <ctype.h>
#include <Xm/XmAll.h>

#include "gps.h"
#include "main.h"
#include "xastir.h"
#include "interface.h"
#include "lang.h"
#include "db.h"
#include "util.h"


char gps_gprmc[MAX_GPS_STRING];
char gps_gpgga[MAX_GPS_STRING];

int got_gps_gprmc;
int got_gps_gpgga;
int gps_stop_now;


int decode_gps_rmc(char *data, char *long_pos, char *lat_pos, char *spd, char *unit, char *cse) {
    char *temp_ptr;
    char temp_data[MAX_TNC_LINE_SIZE+1];    // Big in case we get concatenated packets (it happens!)
    char long_pos_x[10];
    char long_ew;
    char lat_pos_y[9];
    char lat_ns;
    char speed[9];
    char speed_unit;
    char course[7];
    int ok;

    ok=0;
    if (strncmp(data,"$GPRMC,",7)==0) {
        if(strchr(data,',')!=NULL) {
            (void)strtok(data,",");   /* get gprmc */
            (void)strtok(NULL,",");   /* get temp */
            temp_ptr=strtok(NULL,",");  /* get temp */
            if (temp_ptr!=NULL) {
                strncpy(temp_data,temp_ptr,2);
                if (temp_data[0]=='A') {    /* V is a warning but we can get good data still ? */
                    temp_ptr=strtok(NULL,",");  /* get latitude */
                    if (temp_ptr!=NULL && temp_ptr[4]=='.') {
                        strncpy(lat_pos_y,temp_ptr,8);
                        lat_pos_y[8]='\0';
                        temp_ptr=strtok(NULL,",");  /* get N-S */
                        if (temp_ptr!=NULL) {
                            strncpy(temp_data,temp_ptr,1);
                            lat_ns=toupper((int)temp_data[0]);
                            if(lat_ns =='N' || lat_ns =='S') {
                                temp_ptr=strtok(NULL,",");  /* get long */
                                if (temp_ptr!=NULL && temp_ptr[5] == '.') {
                                    strncpy(long_pos_x,temp_ptr,9);
                                    long_pos_x[9]='\0';
                                    temp_ptr=strtok(NULL,",");  /* get E-W */
                                    if (temp_ptr!=NULL) {
                                        strncpy(temp_data,temp_ptr,1);
                                        long_ew=toupper((int)temp_data[0]);
                                        if (long_ew =='E' || long_ew =='W') {
                                            temp_ptr=strtok(NULL,",");  /* Get speed */
                                            if (temp_ptr!=0) {
                                                strncpy(speed,temp_ptr,9);
                                                speed_unit='K';
                                                temp_ptr=strtok(NULL,",");  /* Get course */
                                                if (temp_ptr!=NULL) {
                                                    strncpy(course,temp_ptr,7);
                                                    (void)strtok(NULL,",");   /* get date of fix */
                                                    /* Data good? */
                                                    ok=1;
                                                    sprintf(long_pos,"%s%c",long_pos_x,long_ew);
                                                    sprintf(lat_pos,"%s%c",lat_pos_y,lat_ns);
                                                    strcpy(spd,speed);
                                                    sprintf(unit,"%c",speed_unit);
                                                    strcpy(cse,course);
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }
    return(ok);
}


int decode_gps_gga(char *data, char *long_pos, char *lat_pos, char *sats, char *alt) {
    char *temp_ptr;
    char temp_data[MAX_TNC_LINE_SIZE+1];    // Big in case we get concatenated packets (it happens!)
    char long_pos_x[10];
    char long_ew;
    char lat_pos_y[9];
    char lat_ns;
    char sats_visible[4];
    char altitude[8];
    int ok;

    ok=0;
    if (strncmp(data,"$GPGGA,",7)==0) {
        if (strchr(data,',')!=NULL) {
            if (strtok(data,",")!=NULL) {   /* get gpga*/
                if(strtok(NULL,",")!=NULL) { /* get time */
                    temp_ptr = strtok(NULL,","); /* get latitude */
                    if (temp_ptr !=NULL) {
                        strncpy(lat_pos_y,temp_ptr,8);
                        lat_pos_y[8]='\0';
                        temp_ptr = strtok(NULL,",");    /* get N-S */
                        if (temp_ptr!=NULL) {
                            strncpy(temp_data,temp_ptr,1);
                            lat_ns=toupper((int)temp_data[0]);
                            if(lat_ns == 'N' || lat_ns == 'S') {
                                temp_ptr = strtok(NULL,",");                             /* get long */
                                if(temp_ptr!=NULL) {
                                    strncpy(long_pos_x,temp_ptr,9);
                                    long_pos_x[9]='\0';
                                    temp_ptr = strtok(NULL,",");                          /* get E-W */
                                    if (temp_ptr!=NULL) {
                                        strncpy(temp_data,temp_ptr,1);
                                        long_ew=toupper((int)temp_data[0]);
                                        if (long_ew == 'E' || long_ew == 'W') {
                                            temp_ptr = strtok(NULL,",");                    /* get FIX Quality */
                                            if (temp_ptr!=NULL) {
                                                strncpy(temp_data,temp_ptr,2);
                                                 if(temp_data[0]=='1' || temp_data[0] =='2' ) {
                                                    temp_ptr=strtok(NULL,",");                /* Get sats vis */
                                                    if (temp_ptr!=NULL) {
                                                        strncpy(sats_visible,temp_ptr,4);
                                                        temp_ptr=strtok(NULL,",");             /* get hoz dil */
                                                        if (temp_ptr!=NULL) {
                                                            temp_ptr=strtok(NULL,",");          /* Get altitude */
                                                            if (temp_ptr!=NULL) {
                                                                strcpy(altitude,temp_ptr);       /* Get altitude */
                                                                temp_ptr=strtok(NULL,",");       /* get UNIT */
                                                                if (temp_ptr!=NULL) {
                                                                    strncpy(temp_data,temp_ptr,1);/* get UNIT */
                                                                    //alt_unit=temp_data[0];
                                                                    /* Data good? */
                                                                    ok=1;
                                                                    sprintf(long_pos,"%s%c",long_pos_x,long_ew);
                                                                    sprintf(lat_pos,"%s%c",lat_pos_y,lat_ns);
                                                                    strcpy(sats,sats_visible);
                                                                    strcpy(alt,altitude);
                                                                    //sprintf(unit,"%c",alt_unit);
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }
    return(ok);
}


void gps_data_find(char *gps_line_data, int port) {
    char long_pos[20],lat_pos[20],sats[4],alt[8],spd[10],sunit[2],cse[10];

    if (strncmp(gps_line_data,"$GPRMC,",7)==0 && !gps_stop_now) {
        /*printf("Got RMC %s\n",gps_line_data);*/
        statusline(langcode("BBARSTA015"),0);
        strcpy(gps_gprmc,gps_line_data);
        got_gps_gprmc=1;
    }

    if(strncmp(gps_line_data,"$GPGGA,",7)==0 && !gps_stop_now) {
        /*printf("Got GGA %s\n",gps_line_data);*/
        statusline(langcode("BBARSTA016"),0);
        strcpy(gps_gpgga,gps_line_data);
        got_gps_gpgga=1;
    }

    if (got_gps_gpgga==1 && got_gps_gprmc==1){ /* decode data and shutdown gps port for timed interval */
        if (!gps_stop_now) {
            gps_stop_now=1;
            if (decode_gps_rmc(gps_gprmc,long_pos,lat_pos,spd,sunit,cse)==1) { /* mod station data */
                /*printf("RMC <%s> <%s><%s> %c <%s>\n",long_pos,lat_pos,spd,sunit[0],cse);*/
                if (decode_gps_gga(gps_gpgga,long_pos,lat_pos,sats,alt)==1) {     /* mod station data */
                    /*printf("GGA <%s> <%s> <%s> <%s> %c\n",long_pos,lat_pos,sats,alt,aunit[0]);*/
                    got_gps_gpgga=0;
                    got_gps_gprmc=0;
                    /* got GPS data */
                    my_station_gps_change(long_pos,lat_pos,cse,spd,sunit[0],alt,sats);
                    if (port_data[port].device_type == DEVICE_SERIAL_TNC_HSP_GPS){
                        /* return dtr to normal */
                        port_dtr(port,0);
                    }
                }
            }
        }
    }
}

