/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.style;

import com.icl.saxon.Bindery;
import com.icl.saxon.Context;
import com.icl.saxon.Controller;
import com.icl.saxon.DecimalFormatManager;
import com.icl.saxon.KeyManager;
import com.icl.saxon.PreparedStyleSheet;
import com.icl.saxon.PreviewManager;
import com.icl.saxon.RuleManager;
import com.icl.saxon.om.Name;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.om.TextInfo;
import com.icl.saxon.output.OutputDetails;
import com.icl.saxon.style.StyleElement;
import com.icl.saxon.style.XSLGeneralIncorporate;
import com.icl.saxon.style.XSLNamespaceAlias;
import com.icl.saxon.style.XSLOutput;
import com.icl.saxon.style.XSLTemplate;
import com.icl.saxon.trace.SimpleTraceListener;
import com.icl.saxon.trace.TraceListener;
import com.icl.saxon.tree.Stripper;
import java.util.Vector;
import org.xml.sax.SAXException;

public class XSLStyleSheet
extends StyleElement {
    protected static final Name SAXONTRACE = Name.reconstruct("saxon", "http://icl.com/saxon", "trace");
    private boolean wasIncluded = false;
    private int precedence = 0;
    private int minImportPrecedence = 0;
    private XSLStyleSheet importer = null;
    private PreparedStyleSheet stylesheet;
    private Vector topLevel;
    private Stripper stripper = new Stripper();
    private RuleManager ruleManager = new RuleManager();
    private KeyManager keyManager = new KeyManager();
    private DecimalFormatManager decimalFormatManager = new DecimalFormatManager();
    private PreviewManager previewManager = null;
    private String mediaType;
    private boolean usesAliases = false;
    private int numberOfVariables = 0;
    private int largestStackFrame = 0;

    public void setPreparedStyleSheet(PreparedStyleSheet preparedStyleSheet) {
        this.stylesheet = preparedStyleSheet;
    }

    public PreparedStyleSheet getPreparedStyleSheet() {
        if (this.importer != null) {
            return this.importer.getPreparedStyleSheet();
        }
        return this.stylesheet;
    }

    public RuleManager getRuleManager() {
        return this.ruleManager;
    }

    public Stripper getStripper() {
        return this.stripper;
    }

    public KeyManager getKeyManager() {
        return this.keyManager;
    }

    public DecimalFormatManager getDecimalFormatManager() {
        return this.decimalFormatManager;
    }

    public PreviewManager getPreviewManager() {
        return this.previewManager;
    }

    public void setPreviewManager(PreviewManager previewManager) {
        this.previewManager = previewManager;
    }

    public void setPrecedence(int n) {
        this.precedence = n;
    }

    public int getPrecedence() {
        if (this.wasIncluded) {
            return this.importer.getPrecedence();
        }
        return this.precedence;
    }

    public int getMinImportPrecedence() {
        return this.minImportPrecedence;
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public void setImporter(XSLStyleSheet xSLStyleSheet) {
        this.importer = xSLStyleSheet;
    }

    public XSLStyleSheet getImporter() {
        return this.importer;
    }

    public void setWasIncluded() {
        this.wasIncluded = true;
    }

    public boolean wasIncluded() {
        return this.wasIncluded;
    }

    public Vector getTopLevel() {
        return this.topLevel;
    }

    public int allocateSlotNumber() {
        return this.numberOfVariables++;
    }

    public void allocateLocalSlots(int n) {
        if (n > this.largestStackFrame) {
            this.largestStackFrame = n;
        }
    }

    public void prepareAttributes() throws SAXException {
        String[] stringArray = new String[]{"version", "id", "extension-element-prefixes", "exclude-result-prefixes"};
        this.allowAttributes(stringArray);
    }

    protected void processVersionAttribute() throws SAXException {
        this.version = this.getAttributeValue("version");
        if (this.version == null) {
            this.reportAbsence("version");
        }
    }

    protected XSLNamespaceAlias getNamespaceAlias(String string) throws SAXException {
        if (!this.usesAliases) {
            return null;
        }
        Vector vector = this.topLevel;
        int n = vector.size() - 1;
        while (n >= 0) {
            XSLNamespaceAlias xSLNamespaceAlias;
            Object e = vector.elementAt(n);
            if (e instanceof XSLNamespaceAlias && (xSLNamespaceAlias = (XSLNamespaceAlias)e).getStylesheetURI().equals(string)) {
                return xSLNamespaceAlias;
            }
            --n;
        }
        return null;
    }

    public void validate() throws SAXException {
        if (!this.isDocumentElement()) {
            throw new SAXException(this.getDisplayName() + " must be the outermost element");
        }
    }

    public void preprocess() throws SAXException {
        this.spliceIncludes();
        this.processAllAttributes();
        this.validate();
        int n = 0;
        while (n < this.topLevel.size()) {
            Object e = this.topLevel.elementAt(n);
            if (e instanceof StyleElement) {
                ((StyleElement)e).validateSubtree();
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < this.topLevel.size()) {
            Object e = this.topLevel.elementAt(n2);
            if (e instanceof StyleElement) {
                try {
                    ((StyleElement)e).preprocess();
                }
                catch (SAXException sAXException) {
                    throw ((StyleElement)e).styleError(sAXException);
                }
            }
            ++n2;
        }
        this.updateOutputDetails(new OutputDetails());
    }

    public void processAllAttributes() throws SAXException {
        this.prepareAttributes();
        Vector vector = this.topLevel;
        int n = 0;
        while (n < vector.size()) {
            Object e = vector.elementAt(n);
            if (e instanceof StyleElement) {
                try {
                    ((StyleElement)e).processAllAttributes();
                }
                catch (SAXException sAXException) {
                    throw ((StyleElement)e).styleError(sAXException);
                }
            }
            ++n;
        }
    }

    public void initialiseBindery(Bindery bindery) throws SAXException {
        bindery.allocateGlobals(this.numberOfVariables);
        bindery.allocateLocals(this.largestStackFrame);
    }

    public void updateOutputDetails(OutputDetails outputDetails) throws SAXException {
        Vector vector = this.topLevel;
        int n = 0;
        while (n < vector.size()) {
            Object e = vector.elementAt(n);
            if (e instanceof XSLOutput) {
                try {
                    ((XSLOutput)e).setDetails(outputDetails);
                }
                catch (SAXException sAXException) {
                    throw ((StyleElement)e).styleError(sAXException);
                }
            }
            ++n;
        }
        this.mediaType = outputDetails.getMediaType();
    }

    public void process(Context context) throws SAXException {
        Object e;
        int n;
        Controller controller = context.getController();
        String string = this.getAttributeValue(SAXONTRACE);
        if (string != null && string.equals("yes")) {
            controller.setTraceListener(new SimpleTraceListener());
        }
        this.initialiseBindery(context.getBindery());
        Vector vector = this.topLevel;
        boolean bl = controller.isTracing();
        TraceListener traceListener = null;
        if (bl) {
            traceListener = controller.getTraceListener();
            n = 0;
            while (n < vector.size()) {
                e = vector.elementAt(n);
                traceListener.toplevel((NodeInfo)e);
                ++n;
            }
        }
        n = 0;
        while (n < vector.size()) {
            e = vector.elementAt(n);
            if (e instanceof StyleElement) {
                try {
                    if (bl && !(e instanceof XSLTemplate)) {
                        traceListener.enter((StyleElement)e, context);
                        ((StyleElement)e).process(context);
                        traceListener.leave((StyleElement)e, context);
                    } else {
                        ((StyleElement)e).process(context);
                    }
                }
                catch (SAXException sAXException) {
                    throw ((StyleElement)e).styleError(sAXException);
                }
            }
            ++n;
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void spliceIncludes() throws SAXException {
        var1_1 = this.getAllChildNodes();
        var2_2 = var1_1.length;
        var3_3 = false;
        this.topLevel = new Vector<E>(var2_2);
        this.minImportPrecedence = this.precedence;
        var4_4 /* !! */  = this;
        var5_5 = 0;
        while (var5_5 < var2_2) {
            block12: {
                block13: {
                    block11: {
                        var6_6 = var1_1[var5_5];
                        if (!(var6_6 instanceof TextInfo)) break block11;
                        if (!((TextInfo)var6_6).isWhite()) {
                            throw var4_4 /* !! */ .styleError("No character data is allowed between top-level elements");
                        }
                        break block12;
                    }
                    if (var6_6 instanceof XSLNamespaceAlias) {
                        this.usesAliases = true;
                    }
                    var4_4 /* !! */  = (StyleElement)var6_6;
                    if (!(var6_6 instanceof XSLGeneralIncorporate)) break block13;
                    var7_7 = (XSLGeneralIncorporate)var6_6;
                    var7_7.processAttributes();
                    if (var7_7.isImport()) {
                        if (var3_3) {
                            throw var7_7.styleError("xsl:import elements must come first");
                        }
                    } else {
                        var3_3 = true;
                    }
                    var8_8 = var7_7.getIncludedStyleSheet(this, this.precedence);
                    if (var7_7.isImport()) {
                        this.precedence = var8_8.getPrecedence() + 1;
                    } else {
                        this.precedence = var8_8.getPrecedence();
                        var8_8.setWasIncluded();
                    }
                    if (var8_8.usesAliases) {
                        this.usesAliases = true;
                    }
                    var9_9 = var8_8.topLevel;
                    var10_10 = 0;
                    while (var10_10 < var9_9.size()) {
                        block14: {
                            var11_11 = (StyleElement)var9_9.elementAt(var10_10);
                            var12_12 = this.topLevel.size() - 1;
                            if (var12_12 >= 0 && var11_11.getPrecedence() < ((StyleElement)this.topLevel.elementAt(var12_12)).getPrecedence()) ** GOTO lbl43
                            this.topLevel.addElement(var11_11);
                            break block14;
lbl-1000:
                            // 1 sources

                            {
                                --var12_12;
lbl43:
                                // 2 sources

                                ** while (var12_12 >= 0 && var11_11.getPrecedence() < ((StyleElement)this.topLevel.elementAt((int)var12_12)).getPrecedence())
                            }
lbl44:
                            // 1 sources

                            this.topLevel.insertElementAt(var11_11, var12_12 + 1);
                        }
                        ++var10_10;
                    }
                    break block12;
                }
                var3_3 = true;
                this.topLevel.addElement(var6_6);
            }
            ++var5_5;
        }
    }
}

