/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.expr;

import com.icl.saxon.Context;
import com.icl.saxon.expr.BinaryExpression;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.NumericValue;
import com.icl.saxon.expr.Value;
import org.xml.sax.SAXException;

class ArithmeticExpression
extends BinaryExpression {
    public ArithmeticExpression() {
    }

    public ArithmeticExpression(Expression expression, int n, Expression expression2) {
        super(expression, n, expression2);
    }

    public Value evaluate(Context context) throws SAXException {
        return new NumericValue(this.evaluateAsNumber(context));
    }

    public double evaluateAsNumber(Context context) throws SAXException {
        switch (this.operator) {
            case 25: {
                return this.p1.evaluateAsNumber(context) + this.p2.evaluateAsNumber(context);
            }
            case 26: {
                return this.p1.evaluateAsNumber(context) - this.p2.evaluateAsNumber(context);
            }
            case 27: {
                return this.p1.evaluateAsNumber(context) * this.p2.evaluateAsNumber(context);
            }
            case 28: {
                return this.p1.evaluateAsNumber(context) / this.p2.evaluateAsNumber(context);
            }
            case 29: {
                return this.p1.evaluateAsNumber(context) % this.p2.evaluateAsNumber(context);
            }
            case 99: {
                return -this.p2.evaluateAsNumber(context);
            }
        }
        throw new SAXException("Unknown operator in arithmetic expression");
    }

    public int getDataType() {
        return 2;
    }

    public boolean isNumeric() {
        return true;
    }

    public Expression reduce(int n, Context context) throws SAXException {
        if ((this.getDependencies() & n) != 0) {
            ArithmeticExpression arithmeticExpression = new ArithmeticExpression(this.p1.reduce(n, context), this.operator, this.p2.reduce(n, context));
            arithmeticExpression.setStaticContext(this.getStaticContext());
            return ((Expression)arithmeticExpression).simplify();
        }
        return this;
    }
}

