/*-
# X-BASED ABACUS
#
#  Abacus.h
#
###
#
#  Copyright (c) 1994 - 2005	David Albert Bagley, bagleyd@tux.org
#
#  Abacus demo and neat pointers from
#  Copyright (c) 1991 - 1998	Luis Fernandes, elf@ee.ryerson.ca
#
#                   All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee is hereby granted,
#  provided that the above copyright notice appear in all copies and
#  that both that copyright notice and this permission notice appear in
#  supporting documentation, and that the name of the author not be
#  used in advertising or publicity pertaining to distribution of the
#  software without specific, written prior permission.
#
#  This program is distributed in the hope that it will be "useful",
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
*/

/* Public header file for Abacus */

#ifndef _XtAbacus_h
#define _XtAbacus_h

/***********************************************************************
 *
 * Abacus Widget
 *
 ***********************************************************************/

#if 0
#define DEBUG 1
#endif

#ifndef WINVER
#define XtNselectCallback ((char *) "selectCallback")
#define XtNmono ((char *) "mono")
#define XtNreverse ((char *) "reverse")
#define XtNframeColor ((char *) "frameColor")
#define XtNrailColor ((char *) "railColor")
#define XtNbeadColor ((char *) "beadColor")
#define XtNbeadBorder ((char *) "beadBorder")
#define XtNdelay ((char *) "delay")
#define XtNsound ((char *) "sound")
#define XtNbumpSound ((char *) "bumpSound")
#define XtNmoveSound ((char *) "moveSound")
#define XtNbuffer ((char *) "buffer")
#define XtNscript ((char *) "script")
#define XtNdemo ((char *) "demo")
#define XtNdemoPath ((char *) "demoPath")
#define XtNdemoFont ((char *) "demoFont")
#define XtNdemoForeground ((char *) "demoForeground")
#define XtNdemoBackground ((char *) "demoBackground")
#define XtNvertical ((char *) "vertical")
#define XtNslot ((char *) "slot")
#define XtNdiamond ((char *) "diamond")
#define XtNtopOrient ((char *) "topOrient")
#define XtNbottomOrient ((char *) "bottomOrient")
#define XtNtopNumber ((char *) "topNumber")
#define XtNbottomNumber ((char *) "bottomNumber")
#define XtNtopFactor ((char *) "topFactor")
#define XtNbottomFactor ((char *) "bottomFactor")
#define XtNtopSpaces ((char *) "topSpaces")
#define XtNbottomSpaces ((char *) "bottomSpaces")
#define XtNtopPiece ((char *) "topPiece")
#define XtNbottomPiece ((char *) "bottomPiece")
#define XtNtopPiecePercent ((char *) "topPiecePercent")
#define XtNbottomPiecePercent ((char *) "bottomPiecePercent")
#define XtNshiftPercent ((char *) "shiftPercent")
#define XtNsign ((char *) "sign")
#define XtNdecimalPosition ((char *) "decimalPosition")
#define XtNgroupSize ((char *) "groupSize")
#define XtNrails ((char *) "rails")
#define XtNbase ((char *) "base")
#define XtNanomaly ((char *) "anomaly")
#define XtNshiftAnomaly ((char *) "shiftAnomaly")
#define XtNanomalySq ((char *) "anomalySq")
#define XtNshiftAnomalySq ((char *) "shiftAnomalySq")
#define XtNdisplayBase ((char *) "displayBase")
#define XtNromanNumerals ((char *) "romanNumerals")
#define XtNmode ((char *) "mode")
#define XtNformat ((char *) "format")
#define XtNmenu ((char *) "menu")
#define XtNdeck ((char *) "deck")
#define XtNrail ((char *) "rail")
#define XtNnumber ((char *) "number")
#define XtNframed ((char *) "framed")
#define XtNaux ((char *) "aux")
#define XtNmathBuffer ((char *) "mathBuffer")
#define XtNversionOnly ((char *) "versionOnly")
#define XtCMono ((char *) "Mono")
#define XtCReverse ((char *) "Reverse")
#define XtCFrameColor ((char *) "FrameColor")
#define XtCRailColor ((char *) "RailColor")
#define XtCBeadColor ((char *) "BeadColor")
#define XtCBeadBorder ((char *) "BeadBorder")
#define XtCDelay ((char *) "Delay")
#define XtCSound ((char *) "Sound")
#define XtCBumpSound ((char *) "BumpSound")
#define XtCMoveSound ((char *) "MoveSound")
#define XtCBuffer ((char *) "Buffer")
#define XtCScript ((char *) "Script")
#define XtCDemo ((char *) "Demo")
#define XtCDemoPath ((char *) "DemoPath")
#define XtCDemoFont ((char *) "DemoFont")
#define XtCDemoForeground ((char *) "DemoForeground")
#define XtCDemoBackground ((char *) "DemoBackground")
#define XtCVertical ((char *) "Vertical")
#define XtCSlot ((char *) "Slot")
#define XtCDiamond ((char *) "Diamond")
#define XtCTopOrient ((char *) "TopOrient")
#define XtCBottomOrient ((char *) "BottomOrient")
#define XtCTopNumber ((char *) "TopNumber")
#define XtCBottomNumber ((char *) "BottomNumber")
#define XtCTopFactor ((char *) "TopFactor")
#define XtCBottomFactor ((char *) "BottomFactor")
#define XtCTopSpaces ((char *) "TopSpaces")
#define XtCBottomSpaces ((char *) "BottomSpaces")
#define XtCTopPiece ((char *) "TopPiece")
#define XtCBottomPiece ((char *) "BottomPiece")
#define XtCTopPiecePercent ((char *) "TopPiecePercent")
#define XtCBottomPiecePercent ((char *) "BottomPiecePercent")
#define XtCShiftPercent ((char *) "ShiftPercent")
#define XtCSign ((char *) "Sign")
#define XtCDecimalPosition ((char *) "DecimalPosition")
#define XtCGroupSize ((char *) "GroupSize")
#define XtCRails ((char *) "Rails")
#define XtCBase ((char *) "Base")
#define XtCAnomaly ((char *) "Anomaly")
#define XtCShiftAnomaly ((char *) "ShiftAnomaly")
#define XtCAnomalySq ((char *) "AnomalySq")
#define XtCShiftAnomalySq ((char *) "ShiftAnomalySq")
#define XtCDisplayBase ((char *) "DisplayBase")
#define XtCRomanNumerals ((char *) "RomanNumerals")
#define XtCMode ((char *) "Mode")
#define XtCFormat ((char *) "Format")
#define XtCMenu ((char *) "Menu")
#define XtCDeck ((char *) "Deck")
#define XtCRail ((char *) "Rail")
#define XtCNumber ((char *) "Number")
#define XtCFramed ((char *) "Framed")
#define XtCAux ((char *) "Aux")
#define XtCMathBuffer ((char *) "MathBuffer")
typedef struct _AbacusClassRec *AbacusWidgetClass;
typedef struct _AbacusDemoClassRec *AbacusDemoWidgetClass;

extern WidgetClass abacusWidgetClass;
extern WidgetClass abacusDemoWidgetClass;

typedef struct {
	XEvent     *event;
	int         reason;
	char       *buffer, *mathBuffer;
	int         aux, deck, rail, number;
} abacusCallbackStruct;
#endif

#define ABACUS_BASE_DEFAULT (-12)
#define ABACUS_DEMO_DEFAULT (-11)
#define ABACUS_HIDE (-10)
#define ABACUS_CLEAR_QUERY (-9)
#define ABACUS_CALC (-8)
#define ABACUS_MORE (-7)
#define ABACUS_REPEAT (-6)
#define ABACUS_NEXT (-5)
#define ABACUS_DEMO (-4)
#define ABACUS_CLEAR (-3)
#define ABACUS_SCRIPT (-2)
#define ABACUS_IGNORE (-1)
#define ABACUS_MOVE 0
#define ABACUS_DEC 1
#define ABACUS_INC 2
#define ABACUS_VERTICAL 3
#define ABACUS_ROMANNUMERAL 4
#define ABACUS_SIGN 5
#define ABACUS_QUARTER 6
#define ABACUS_QUARTERPERCENT 7
#define ABACUS_TWELFTH 8
#define ABACUS_ANOMALY 9
#define ABACUS_WATCH 10
#define ABACUS_FORMAT 11 

#define PRIMARY 0
#define LEFTAUX 1
#define RIGHTAUX 2
#define MINRAILS 1
#define MINDEMORAILS 3
#define DEFAULTRAILS 13
#define DEFAULTTOPSPACES 2
#define DEFAULTBOTTOMSPACES 2
#define DEFAULTTOPNUMBER 2
#define DEFAULTBOTTOMNUMBER 5
#define DEFAULTTOPFACTOR 5
#define DEFAULTBOTTOMFACTOR 1
#define DEFAULTTOPORIENT TRUE
#define DEFAULTBOTTOMORIENT FALSE
#ifdef MONOTEST
#define DEFAULTMONO TRUE
#else
#define DEFAULTMONO FALSE
#endif
#define DEFAULTREVERSE FALSE
#define CHINESE 0
#define JAPANESE 1
#define KOREAN 2
#define ROMAN 3
#define RUSSIAN 4
#define OTHER 5
#define MAXFORMATS 5
#define MAXMODES 6
#define MINBASE 2 /* Base 1 is rediculous :) */
#define MAXBASE 36 /* 10 numbers + 26 letters (ASCII) */
#define DEFAULTBASE 10
#define QUARTERS 4
#define QUARTERPERCENTS 4
#define TWELFTH 12

typedef struct _AbacusRec *AbacusWidget;
typedef struct _AbacusRec *AbacusDemoWidget;

#endif /* _XtAbacus_h */
/* DON'T ADD STUFF AFTER THIS #endif */
