/***************************************
  $Header: /home/amb/wwwoffle/src/RCS/monitor.c 1.39 2001/09/24 18:24:18 amb Exp $

  WWWOFFLE - World Wide Web Offline Explorer - Version 2.7.
  The functions for monitoring URLs.
  ******************/ /******************
  Written by Andrew M. Bishop

  This file Copyright 1998,99,2000,01 Andrew M. Bishop
  It may be distributed under the GNU Public License, version 2, or
  any higher version.  See section COPYING of the GNU Public license
  for conditions under which this file may be redistributed.
  ***************************************/


#include "autoconfig.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include <sys/types.h>
#include <unistd.h>

#if TIME_WITH_SYS_TIME
# include <sys/time.h>
# include <time.h>
#else
# if HAVE_SYS_TIME_H
#  include <sys/time.h>
# else
#  include <time.h>
# endif
#endif

#include <utime.h>
#include <sys/stat.h>

#if HAVE_DIRENT_H
# include <dirent.h>
#else
# define dirent direct
# if HAVE_SYS_NDIR_H
#  include <sys/ndir.h>
# endif
# if HAVE_SYS_DIR_H
#  include <sys/dir.h>
# endif
# if HAVE_NDIR_H
#  include <ndir.h>
# endif
#endif

#include <fcntl.h>

#include "wwwoffle.h"
#include "misc.h"
#include "config.h"
#include "errors.h"

/*+ Need this for Win32 to use binary mode +*/
#ifndef O_BINARY
#define O_BINARY 0
#endif

static void MonitorFormShow(int fd,char *request_args);
static void MonitorFormParse(int fd,char *request_args,Body *request_body);

/*+ The file descriptor of the sppol directory. +*/
extern int fSpoolDir;


/*++++++++++++++++++++++++++++++++++++++
  Send to the client a page to allow monitoring using HTML.

  int fd The file descriptor of the client.

  URL *Url The URL that was used to request this page.

  Body *request_body The body of the HTTP request.
  ++++++++++++++++++++++++++++++++++++++*/

void MonitorPage(int fd,URL *Url,Body *request_body)
{
 if(!strcmp("/monitor-options/",Url->path))
    MonitorFormShow(fd,Url->args);
 else if(!strcmp("/monitor-request/",Url->path))
    MonitorFormParse(fd,Url->args,request_body);
 else
    HTMLMessage(fd,404,"WWWOFFLE Illegal Monitor Page",NULL,"MonitorIllegal",
                "url",Url->pathp,
                NULL);
}


/*++++++++++++++++++++++++++++++++++++++
  Create the the form.

  int fd The file descriptor of the client.

  char *request_args The arguments to the requesting URL.
  ++++++++++++++++++++++++++++++++++++++*/

static void MonitorFormShow(int fd,char *request_args)
{
 char MofY[13],DofM[32],DofW[8],HofD[25];
 char dofmstr[128],hofdstr[64],*p;
 char *url=NULL;
 URL *monUrl=NULL;
 int i;

 if(request_args)
    url=URLDecodeFormArgs(request_args);

 if(url && (monUrl=SplitURL(url)))
    ReadMonitorTimesSpoolFile(monUrl,MofY,DofM,DofW,HofD);
 else
   {
    strcpy(MofY,"111111111111");
    strcpy(DofM,"1111111111111111111111111111111");
    strcpy(DofW,"1111111");
    strcpy(HofD,"100000000000000000000000");
   }

 if(!strcmp(DofM,"1111111111111111111111111111111"))
    strcpy(dofmstr,"");
 else
   {
    *dofmstr=0;
    p=dofmstr;
    for(i=0;i<31;i++)
       if(DofM[i]=='1')
         {
          sprintf(p,"%d ",i+1);
          p+=strlen(p);
         }
   }

 if(!strcmp(HofD,"100000000000000000000000"))
    strcpy(hofdstr,"");
 else
   {
    *hofdstr=0;
    p=hofdstr;
    for(i=0;i<24;i++)
       if(HofD[i]=='1')
         {
          sprintf(p,"%d ",i);
          p+=strlen(p);
         }
   }

 HTMLMessage(fd,200,"WWWOFFLE Monitor Page",NULL,"MonitorPage",
             "url",url,
             "mofy1",MofY[0]=='1'?"Yes":NULL,
             "mofy2",MofY[1]=='1'?"Yes":NULL,
             "mofy3",MofY[2]=='1'?"Yes":NULL,
             "mofy4",MofY[3]=='1'?"Yes":NULL,
             "mofy5",MofY[4]=='1'?"Yes":NULL,
             "mofy6",MofY[5]=='1'?"Yes":NULL,
             "mofy7",MofY[6]=='1'?"Yes":NULL,
             "mofy8",MofY[7]=='1'?"Yes":NULL,
             "mofy9",MofY[8]=='1'?"Yes":NULL,
             "mofy10",MofY[9]=='1'?"Yes":NULL,
             "mofy11",MofY[10]=='1'?"Yes":NULL,
             "mofy12",MofY[11]=='1'?"Yes":NULL,
             "dofm",dofmstr,
             "dofw0",DofW[0]=='1'?"Yes":NULL,
             "dofw1",DofW[1]=='1'?"Yes":NULL,
             "dofw2",DofW[2]=='1'?"Yes":NULL,
             "dofw3",DofW[3]=='1'?"Yes":NULL,
             "dofw4",DofW[4]=='1'?"Yes":NULL,
             "dofw5",DofW[5]=='1'?"Yes":NULL,
             "dofw6",DofW[6]=='1'?"Yes":NULL,
             "hofd",hofdstr,
             NULL);

 free(url);
}


/*++++++++++++++++++++++++++++++++++++++
  Parse the reply from the form.

  int fd The file descriptor of the client.

  char *request_args The arguments to the requesting URL.

  Body *request_body The body of the HTTP request sent by the browser.
  ++++++++++++++++++++++++++++++++++++++*/

static void MonitorFormParse(int fd,char *request_args,Body *request_body)
{
 int i,mfd=-1;
 char **args,*url=NULL;
 URL *Url;
 char mofy[12]="NNNNNNNNNNNN",*dofm=NULL,dofw[7]="NNNNNNN",*hofd=NULL;
 char MofY[13],DofM[32],DofW[8],HofD[25];

 if(!request_args && !request_body)
   {
    HTMLMessage(fd,404,"WWWOFFLE Monitor Form Error",NULL,"MonitorFormError",
                "body",NULL,
                NULL);
    return;
   }

 if(request_body)
   {
    char *form=URLRecodeFormArgs(request_body->content);
    args=SplitFormArgs(form);
    free(form);
   }
 else
    args=SplitFormArgs(request_args);

 for(i=0;args[i];i++)
   {
    if(!strncmp("url=",args[i],4))
       url=args[i]+4;
    if(!strncmp("mofy1=",args[i],6))
       mofy[0]=args[i][6];
    if(!strncmp("mofy2=",args[i],6))
       mofy[1]=args[i][6];
    if(!strncmp("mofy3=",args[i],6))
       mofy[2]=args[i][6];
    if(!strncmp("mofy4=",args[i],6))
       mofy[3]=args[i][6];
    if(!strncmp("mofy5=",args[i],6))
       mofy[4]=args[i][6];
    if(!strncmp("mofy6=",args[i],6))
       mofy[5]=args[i][6];
    if(!strncmp("mofy7=",args[i],6))
       mofy[6]=args[i][6];
    if(!strncmp("mofy8=",args[i],6))
       mofy[7]=args[i][6];
    if(!strncmp("mofy9=",args[i],6))
       mofy[8]=args[i][6];
    if(!strncmp("mofy10=",args[i],7))
       mofy[9]=args[i][7];
    if(!strncmp("mofy11=",args[i],7))
       mofy[10]=args[i][7];
    if(!strncmp("mofy12=",args[i],7))
       mofy[11]=args[i][7];
    if(!strncmp("dofm=",args[i],5))
       dofm=args[i]+5;
    if(!strncmp("dofw0=",args[i],6))
       dofw[0]=args[i][6];
    if(!strncmp("dofw1=",args[i],6))
       dofw[1]=args[i][6];
    if(!strncmp("dofw2=",args[i],6))
       dofw[2]=args[i][6];
    if(!strncmp("dofw3=",args[i],6))
       dofw[3]=args[i][6];
    if(!strncmp("dofw4=",args[i],6))
       dofw[4]=args[i][6];
    if(!strncmp("dofw5=",args[i],6))
       dofw[5]=args[i][6];
    if(!strncmp("dofw6=",args[i],6))
       dofw[6]=args[i][6];
    if(!strncmp("hofd=",args[i],5))
       hofd=args[i]+5;
   }

 if(url==NULL || *url==0)
   {
    HTMLMessage(fd,404,"WWWOFFLE Monitor Form Error",NULL,"MonitorFormError",
                "body",request_body?request_body->content:request_args,
                NULL);
    free(args[0]);
    free(args);
    return;
   }

 url=URLDecodeFormArgs(url);
 Url=SplitURL(url);

 /* Parse the requested time */

 strcpy(MofY,"000000000000");
 for(i=0;i<12;i++)
    if(mofy[i]=='Y')
       MofY[i]='1';

 if(!*dofm)
    strcpy(DofM,"1111111111111111111111111111111");
 else
   {
    int d,any=0;
    char *p=dofm;
    strcpy(DofM,"0000000000000000000000000000000");

    while(*p)
      {
       while(*p && !isdigit(*p))
          p++;
       if(!*p)
          break;
       d=atoi(p)-1;
       if(d>=0 && d<31)
         {
          DofM[d]='1';
          any++;
         }
       while(isdigit(*p))
          p++;
      }

    if(!any)
       strcpy(DofM,"1111111111111111111111111111111");
   }

 strcpy(DofW,"0000000");
 for(i=0;i<7;i++)
    if(dofw[i]=='Y')
       DofW[i]='1';

 if(!*hofd)
    strcpy(HofD,"100000000000000000000000");
 else
   {
    int h,any=0;
    char *p=hofd;
    strcpy(HofD,"000000000000000000000000");

    while(*p)
      {
       while(*p && !isdigit(*p))
          p++;
       if(!*p)
          break;
       h=atoi(p);
       if(h>=0 && h<24)
         {
          HofD[h]='1';
          any++;
         }
       while(isdigit(*p))
          p++;
      }

    if(!any)
       strcpy(HofD,"100000000000000000000000");
   }

 mfd=CreateMonitorSpoolFile(Url,MofY,DofM,DofW,HofD);
 init_buffer(mfd);

 if(mfd==-1)
    HTMLMessage(fd,500,"WWWOFFLE Server Error",NULL,"ServerError",
                "error","Cannot open file to store monitor request",
                NULL);
 else
   {
    Header *new_request_head=RequestURL(Url,NULL);
    char *head=HeaderString(new_request_head);

    write_string(mfd,head);

    close(mfd);

    HTMLMessage(fd,200,"WWWOFFLE Monitor Will Get",NULL,"MonitorWillGet",
                "url",Url->name,
                NULL);

    free(head);
    FreeHeader(new_request_head);
   }

 free(args[0]);
 free(args);

 FreeURL(Url);
}


/*++++++++++++++++++++++++++++++++++++++
  Convert monitor requests into outgoing requests.
  ++++++++++++++++++++++++++++++++++++++*/

void RequestMonitoredPages(void)
{
 DIR *dir;
 struct dirent* ent;

 /* Open the monitor subdirectory. */

 if(chdir("monitor"))
   {PrintMessage(Warning,"Cannot change to directory 'monitor'; [%!s] no files monitored.");return;}

 dir=opendir(".");
 if(!dir)
   {PrintMessage(Warning,"Cannot open directory 'monitor'; [%!s] no files monitored.");fchdir(fSpoolDir);return;}

 ent=readdir(dir);  /* skip .  */
 if(!ent)
   {PrintMessage(Warning,"Cannot read directory 'monitor'; [%!s] no files monitored.");closedir(dir);fchdir(fSpoolDir);return;}
 ent=readdir(dir);  /* skip .. */

 /* Scan through all of the files. */

 while((ent=readdir(dir)))
   {
    struct stat buf;

    if(stat(ent->d_name,&buf))
      {PrintMessage(Inform,"Cannot stat file 'monitor/%s'; [%!s] race condition?",ent->d_name);return;}
    else if(S_ISREG(buf.st_mode) && *ent->d_name=='O')
      {
       char *url=FileNameToURL(ent->d_name),*file;
       URL *Url=SplitURL(url);
       int last,next;

       fchdir(fSpoolDir);

       MonitorTimes(Url,&last,&next);

       PrintMessage(Debug,"Monitoring '%s' last=%dh next=%dh => %s",Url->name,last,next,next?"No":"Yes");

       chdir("monitor");

       if(next==0)
         {
          int ifd=open(ent->d_name,O_RDONLY|O_BINARY);
          init_buffer(ifd);

          if(ifd==-1)
             PrintMessage(Warning,"Cannot open monitored file 'monitor/%s' to read [%!s].",ent->d_name);
          else
            {
             int ofd;

             fchdir(fSpoolDir);

             ofd=OpenOutgoingSpoolFile(0);
             init_buffer(ofd);

             if(ofd==-1)
                PrintMessage(Warning,"Cannot open outgoing spool file for monitored URL '%s'; [%!s].",url);
             else
               {
                char *contents=(char*)malloc(buf.st_size+1);
                URL *Url=SplitURL(url);

                read_data(ifd,contents,buf.st_size);
                if(write_data(ofd,contents,buf.st_size)==-1)
                   PrintMessage(Warning,"Cannot write to outgoing file; disk full?");

                CloseOutgoingSpoolFile(ofd,Url);

                free(contents);
                FreeURL(Url);
               }

             chdir("monitor");

             close(ifd);
             free(url);

             file=URLToFileName(Url);
             *file='M';
             utime(file,NULL);
             free(file);
            }
         }

       FreeURL(Url);
      }
   }

 fchdir(fSpoolDir);

 closedir(dir);
}


/*++++++++++++++++++++++++++++++++++++++
  Calculate the monitoring interval and times of previous and next monitoring.

  URL *Url The URL of the file to check for.

  int *last The time in hours ago that the file was last monitored.

  int *next The time in hours from now that it should next be monitored.
  ++++++++++++++++++++++++++++++++++++++*/

void MonitorTimes(URL *Url,int *last,int *next)
{
 time_t now=time(NULL),then,when;
 char MofY[13],DofM[32],DofW[8],HofD[25];
 int mofy,dofm,dofw,hofd;
 struct tm *tim;

 then=ReadMonitorTimesSpoolFile(Url,MofY,DofM,DofW,HofD);

 now =3600*(now/3600);
 then=3600*(then/3600);

 if(then>now)
    then=now;

 mofy=dofm=dofw=hofd=0;
 for(when=then+3600;when<=now;when+=3600)
   {
    if(hofd==0)
      {
       tim=localtime(&when);
       mofy=tim->tm_mon;
       dofm=tim->tm_mday-1;
       dofw=tim->tm_wday;
       hofd=tim->tm_hour;
      }

    if(MofY[mofy]=='1' && DofM[dofm]=='1' && DofW[dofw]=='1' && HofD[hofd]=='1')
      {*next=0;break;}

    hofd=(hofd+1)%24;
   }

 if(when>now)
   {
    hofd=0;
    for(when=now+3600;when<(now+31*24*3600);when+=3600)
      {
       if(hofd==0)
         {
          tim=localtime(&when);
          mofy=tim->tm_mon;
          dofm=tim->tm_mday-1;
          dofw=tim->tm_wday;
          hofd=tim->tm_hour;
         }

       if(MofY[mofy]=='1' && DofM[dofm]=='1' && DofW[dofw]=='1' && HofD[hofd]=='1')
          break;

       hofd=(hofd+1)%24;
      }

    *next=(when-now)/3600;
   }

 *last=(now-then)/3600;
}
