/*
 *   Copyright (C) 2002-2004 by Jonathan Naylor G4KLX
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef	JT44Frame_H
#define	JT44Frame_H

#include <wx/wx.h>
#include <wx/listctrl.h>
#include <wx/notebook.h>
#include <wx/spinctrl.h>

#include "common/RecordControl.h"
#include "common/TransmitControl.h"
#include "common/RemoteControl.h"
#include "common/MessageControl.h"
#include "common/LevelEvent.h"
#include "common/ErrorEvent.h"
#include "common/ClockPanel.h"
#include "common/Receive.h"

#include "JT44Levels.h"
#include "JT44Message.h"
#include "JT44Display.h"
#include "JT44SunMoonDisplay.h"
#include "JT44LevelEvent.h"
#include "JT44MessageEvent.h"

class CJT44Frame : public wxFrame {
    public:
	CJT44Frame();
	virtual ~CJT44Frame();

	virtual void onOpen(const wxCommandEvent& event);
	virtual void onSaving(const wxCommandEvent& event);
	virtual void onDelete(const wxCommandEvent& event);
	virtual void onQuit(const wxCommandEvent& event);
	virtual void onPreferences(const wxCommandEvent& event);
	virtual void onAbout(const wxCommandEvent& event);

	virtual void onRecord(const wxCommandEvent& event);
	virtual void onTXOrder(const wxCommandEvent& event);
	virtual void onTXEnable(const wxCommandEvent& event);
	virtual void onUpdate(const wxCommandEvent& event);
	virtual void onText(const wxCommandEvent& event);
	virtual void onChoice(const wxCommandEvent& event);
	virtual void onBand(const wxCommandEvent& event);

	virtual void onLevels(const CJT44LevelEvent& event);
	virtual void onMessage(const CJT44MessageEvent& event);
	virtual void onAudio(const CLevelEvent& event);

	virtual void onError(const CErrorEvent& event);

	virtual void showLevels(CJT44Levels* levels, EWho who);
	virtual void showMessage(CJT44Message* message, EWho who);
	virtual void showAudio(double audio, EWho who);

	virtual void error(const wxString& error);

    private:
	CJT44Display*         m_firstDisplay;
	CJT44Display*         m_secondDisplay;
	CJT44Display*         m_fileDisplay;
	CJT44SunMoonDisplay*  m_sunMoonDisplay;
	CRecordControl*       m_record;
	CTransmitControl*     m_transmit;
	CRemoteControl*       m_remote;
	CClockPanel*          m_clock;
	CMessageControl*      m_message;
	int                   m_messageNo;

	DECLARE_EVENT_TABLE()

	wxMenuBar* createMenuBar();
};

#endif
