/*
 *   Copyright (C) 2002-2004 by Jonathan Naylor G4KLX
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "FSK441ProtocolPreferences.h"

const int BORDER_SIZE = 5;

CFSK441ProtocolPreferences::CFSK441ProtocolPreferences(wxWindow* parent, int id, int minLength, int minStrength, int maxOffset) :
wxPanel(parent, id),
m_length(NULL),
m_strength(NULL),
m_offset(NULL)
{
	wxFlexGridSizer* sizer = new wxFlexGridSizer(2);

	wxStaticText* lengthLabel = new wxStaticText(this, -1, wxT("Length (ms)"));
	sizer->Add(lengthLabel, 0, wxTOP, BORDER_SIZE);

	m_length = new wxSpinCtrl(this, -1);
	m_length->SetValue(minLength);
	m_length->SetRange(20, 1000);
	sizer->Add(m_length, 0, wxALL, BORDER_SIZE);

	wxStaticText* strengthLabel = new wxStaticText(this, -1, wxT("Strength (dB)"));
	sizer->Add(strengthLabel, 0, wxTOP, BORDER_SIZE);

	m_strength = new wxSpinCtrl(this, -1);
	m_strength->SetValue(minStrength);
	m_strength->SetRange(1, 20);
	sizer->Add(m_strength, 0, wxALL, BORDER_SIZE);

	wxStaticText* offsetLabel = new wxStaticText(this, -1, wxT("Offset (Hz)"));
	sizer->Add(offsetLabel, 0, wxTOP, BORDER_SIZE);

	m_offset = new wxSpinCtrl(this, -1);
	m_offset->SetValue(maxOffset);
	m_offset->SetRange(40, 400);
	sizer->Add(m_offset, 0, wxALL, BORDER_SIZE);

	SetAutoLayout(true);

	sizer->Fit(this);
	sizer->SetSizeHints(this);

	SetSizer(sizer);
}

CFSK441ProtocolPreferences::~CFSK441ProtocolPreferences()
{
}

int CFSK441ProtocolPreferences::getMinLength() const
{
	wxASSERT(m_length != NULL);

	return m_length->GetValue();
}

int CFSK441ProtocolPreferences::getMinStrength() const
{
	wxASSERT(m_strength != NULL);

	return m_strength->GetValue();
}

int CFSK441ProtocolPreferences::getMaxOffset() const
{
	wxASSERT(m_offset != NULL);

	return m_offset->GetValue();
}
