/*
 *   Copyright (C) 2002-2004 by Jonathan Naylor G4KLX
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef	FSK441Defs_H
#define	FSK441Defs_H

const int FSK441_SAMPLE_RATE    = 11025;
const int FSK441_SYMBOL_LENGTH  = 25;
const int FSK441_FFT_LENGTH     = 256;
const int FSK441_CHAR_LENGTH    = 3;

const int FSK441_BIN_WIDTH  = FSK441_SAMPLE_RATE / FSK441_FFT_LENGTH;

const int FSK441_TONE0_FREQ = 882;
const int FSK441_TONE1_FREQ = 1323;
const int FSK441_TONE2_FREQ = 1764;
const int FSK441_TONE3_FREQ = 2205;

const int FSK441_TONE_SPACING = 441 / FSK441_BIN_WIDTH;

const int FSK441_TONE0_BIN  = FSK441_TONE0_FREQ / FSK441_BIN_WIDTH;
const int FSK441_TONE1_BIN  = FSK441_TONE0_BIN + FSK441_TONE_SPACING;
const int FSK441_TONE2_BIN  = FSK441_TONE1_BIN + FSK441_TONE_SPACING;
const int FSK441_TONE3_BIN  = FSK441_TONE2_BIN + FSK441_TONE_SPACING;

const int FSK441_MAX_AUDIO_DATA = 30 * FSK441_SAMPLE_RATE;

const double FSK441_SEND_VOLUME = 0.5;

const double FSK441_MIN_RATIO = 2.0;

const int FSK441_MAX_MESSAGE_LENGTH = 30;

const int FSK441_SOUNDBUF_LENGTH = 2048;

// For the GUI
const wxString FSK441_LOGFILE_NAME  = wxT("fsk441");
const wxString FSK441_LOGFILE_EXT   = wxT("log");
const wxString FSK441_MESSAGES_NAME = wxT("fsk441");
const wxString FSK441_MESSAGES_EXT  = wxT("cum");

const wxString title = wxT("FSK441 (WS Tools 0.4.8d)");

const int FSK441_MAX_MESSAGES   = 6;

const int FSK441_LEVEL_WIDTH     = 570;
const int FSK441_AUDIO_WIDTH     = 25;
const int FSK441_GRAPH_HEIGHT    = 125;
const int FSK441_MESSAGES_WIDTH  = 600;
const int FSK441_MESSAGES_HEIGHT = 150;

const int FSK441_NUM_COLOURS     = 16;

// For the configuration
const wxString FSK441_VENDOR_NAME = wxT("G4KLX");
const wxString FSK441_APPL_NAME   = wxT("FSK441");

#endif
