/*
$Id: audio_hpux.c,v 1.3 1999/07/24 22:01:14 daeron Exp $
*/

#include <sys/audio.h>

int
SPerformAudio(SAudioFileInfo *afInfo)
{
	Audio		*audio;		/* The audio structure			*/
	AGainEntry	gainEntry[4];	/* Used to set playback parameters	*/
	AGainMatrix	*gainMatrix;	/* Used for setting gain matrix		*/
	ATransID	xid;		/* The transaction ID			*/
	AFileFormat	fileFormat;	/* Receives the audio file format	*/
	AudioAttrMask	attribMask;	/* Attribute mask			*/
	AudioAttributes	attribs;	/* Audio attributes			*/
	SBucket		*soundBucket;	/* Sound bucket structure		*/
	SBPlayParams	*playParams;	/* Play parameters			*/
	char		*serverName;	/* To identify audio server		*/
	AEvent		event;		/* An audio event			*/
	long		status;
	int		done = 0;
	
	fileFormat = AFFunknown;
	serverName = "";	/* play on the local server */
	attribMask = 0;
	
	/* open connection to the audio server */
	audio = AOpenAudio(ServerName, NULL);
	
	/* load the audio file into a sound bucker */
	soundBucket = ALoadAFile(audio, afInfo->Path, fileFormat, attribMask,
			&attribs, NULL);
	
	/* setup the playback parameters. Use ASimplePlayer() to get the
	 * simplest output gain matrix supported by the audio hardware
	 */
	memset(&playParams, 0, sizeof(playParams));
	playParams.gain_matrix = *ASimplePlayer(audio);
	playParams.priority = APriorityNormal;		/* normal priority		*/
	playParams.play_volume = AUnityGain;		/* no change to play volume	*/
	playParams.duration.type = ATTFullLength;	/* play entire sample		*/
	playParams.event_mask = ATransCompletedMask;	/* let us know when we're done	*/
	
	/* play the sound bucket */
	xid = APlaySBucket(audio, soundBucket, &playParams, 0);

	while (!done) {
		ANextEvent(audio, &event, &status);
		switch	(event.any_event.type) {
			case AETTransCompleted:
				done = 1;
				break;
			default:
				swarning("Unknown AudioEvent %d", event.any_event.type);
				break;
		}
	}
	
	/* set close mode to prevent playback from stopping when we close the audio connection */
	ASetCloseDownMode(audio, AKeepTransactions, NULL);
	
	/* That's all, folks! */
	ADestroySBucket(audio, soundBucket, NULL);
	ACloseAudio(audio, NULL);
	
	return 0;
}

