/* Copyright 2001 Matt Flax <flatmax@ieee.org>
   This file is part of MFFM Time Scale Modification for Audio.

   MFFM Time Scale Modification for Audio is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   MFFM Time Scale Modification for Audio is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You have received a copy of the GNU General Public License
   along with MFFM Time Scale Modification for Audio
 */
#ifndef HANNING_H_
#define HANNING_H_

#include <iostream>
//#include <fstream>
#include <math.h>

//#define H_DEBUG

class Hanning {
protected:
  int cnt, wnd_cnt;
  double *wnd;

public:
  Hanning(int windowSize){
#ifdef H_DEBUG
    std::cout<<"Hanning::Hanning enter "<<this<<std::endl;
#endif
    cnt=0;
    wnd=NULL;
    reset(windowSize);
#ifdef H_DEBUG
    std::cout<<"Hanning::Hanning exit"<<std::endl;
#endif
  }

  ~Hanning(void){
#ifdef H_DEBUG
    std::cout<<"Hanning::~Hanning"<<std::endl;
#endif
    if (wnd) delete [] wnd;
    wnd=NULL;
  }

  void reset(int count){
#ifdef H_DEBUG
    std::cout<<"Hanning::reset enter"<<std::endl;
#endif
    wnd_cnt=count;
    //std::cout<<count<<'\t'<<cnt<<std::endl;
    if (count>cnt){
      cnt=count;
      if (wnd)
	delete [] wnd;
      wnd=NULL;
      //    std::cout<<wnd_cnt<<std::endl;
      if (!(wnd=new double[wnd_cnt])){
	std::cerr<<"Hanning::Hanning : hanning window malloc fail"<<std::endl;
	exit(-1);
      }
    }
    for (int i=0;i<wnd_cnt;i++)
      wnd[i]=0.5-0.5*cos(2.0*M_PI*i/(wnd_cnt-1));
#ifdef H_DEBUG
    std::cout<<"Hanning::reset exit "<<wnd<<std::endl;
#endif
  }

  int getCount(){return wnd_cnt;}

  double operator[](int i){return wnd[i];}
};

template <class DATATYPE>
class HanningApplyer : public Hanning {
public:
  HanningApplyer(int windowSize) : Hanning(windowSize){}

  void process(DATATYPE *data){
    //    std::ofstream output("wnd.txt"); for (int i=0;i<wnd_cnt;i++) output<<wnd[i]<<'\n'; output.close();

    for (int i=0;i<wnd_cnt;i++)
      data[i]=(DATATYPE)((double)data[i]*wnd[i]);
  }
};
#endif //HANNING_H_
