#if defined(TT_2)
#include <stdio.h>
#include <iconv.h>
#include "wprint.h"

extern int verbose;
extern void FTError(char *,int);

int	initTT(struct tt_info *ti)
{
	return(FT_Init_FreeType(&(ti->ttengine)));
}

int createGlyphs (FILE *out,struct tt_info *ti,unsigned short unicode,char *b64name)
{
FT_Error error;
unsigned short index;

  	if (ti->font.ttface == NULL)
		Error("Couldn't find suitable Cmap");

	index = FT_Get_Char_Index(ti->font.ttface,unicode );

	if((error=FT_Load_Glyph(ti->font.ttface, index, FT_LOAD_NO_SCALE)))
		FTError("Couldn't load glyph", error);
	glyphToPs(out,unicode,ti,b64name);

	return 0;
}
void finalizeFT(struct tt_info *ti)
{
FT_Error error;

	if ((error=FT_Done_FreeType(ti->ttengine)) != 0)
		FTError("Coudn't finalise FreeType engine", error);
	return;
}

int glyphToPs(FILE *out,unsigned short unicode,struct tt_info *ti,char *b64name)
{
FT_BBox			bbox;
FT_Outline		outline;
FT_Glyph		image;
int			error;

int ncontours,len,ncurves;/* ojo */

	fprintf(out,"/%s { %% U%04X\n",b64name,unicode);
	ncurves = 0;

	error = FT_Get_Glyph(ti->font.ttface->glyph,&image);
	if (error != 0)
	{
		FTError("Coudn't get glyph", error);
	}
	FT_Outline_Get_BBox(&(ti->font.ttface->glyph->outline),&bbox);

	fprintf(out,"%ld 0 %ld %ld %ld %ld setcachedevice\n",
	(signed long) ti->font.ttface->glyph->metrics.horiAdvance,
	bbox.xMin, bbox.yMin, bbox.xMax, bbox.yMax);

	outline = ti->font.ttface->glyph->outline;

	len = 1; /* Check later */

	if (len != 0)
	{
		ncontours = outline.n_contours;
		if (ncontours > 0)
			ncurves += drawGlyph(out,ti);
			/*ncurves += drawGlyph(out,glyph, glyph,outline);*/

		if (ncurves > 100)
			fprintf(out,"%% This glyph is too long, may have to be removed\n");
	}
	fprintf(out,"fill } bind def\n");
	return(0);
}

int drawGlyph(FILE *out,struct tt_info *ti)
{
int		i, j, k, k1, first, cs, ce;
int		finished, nguide, contour_start, contour_end;
short		ncontours, last_point;
unsigned short	*contour_end_pt;
short		xcoord[2000], ycoord[2000];
unsigned char	flags[2000];
char		pfa_file[256];
int		ncurves;
FT_Vector	*vec;
FT_Outline	outline;

	ncurves =0;

	outline = ti->font.ttface->glyph->outline;
	contour_start = 0;
	ce = contour_start;

	ncontours = outline.n_contours;

	if (ncontours <= 0)
	{
		fprintf(out,"%%**** Composite glyph %04x refers to non-existent glyph",1);
		return 0;
	}
	contour_end_pt = (unsigned short *) outline.contours;

	last_point = outline.n_points;

	j = k = 0;
	for (k = 0;k <= last_point;k++)
		flags[k] = outline.tags[k];

	vec = outline.points;
	for (k=0; k <= last_point; k++)
	{
		xcoord[k] = vec[k].x;
		ycoord[k] = vec[k].y;
	}

	i = j = 0;
	first = 1;

	while (i <= outline.contours[outline.n_contours - 1])
	{
		contour_end = outline.contours[j];

		if (first)
		{
			sprintf(pfa_file, "%d %d moveto\n", xcoord[i], ycoord[i]);
			fprintf(out,pfa_file);
			ncurves ++;
			contour_start = i;
			first = 0;
		}
		else if (flags[i] & ONOROFF)
		{
			sprintf(pfa_file, "%d %d lineto\n", xcoord[i], ycoord[i]);
			fprintf(out,pfa_file);
			ncurves ++;
		}
		else
		{
			cs = i-1;
			finished = nguide = 0;
			while (!finished)
			{
				if (i == contour_end+1)
				{
					ce = contour_start;
					finished = 1;
				}
				else if (flags[i] & ONOROFF)
				{
					ce = i;
					finished = 1;
				}
				else
				{
					i++;
					nguide++;
				}
			}

			switch (nguide)
			{
			case 0: 
				sprintf( pfa_file,"%d %d lineto\n",
				xcoord[ce], ycoord[ce]);
				fprintf(out,pfa_file);
				ncurves ++;
				break;

			case 1:
				sprintf( pfa_file, "%d %d %d %d %d %d curveto\n",
				(xcoord[cs]+2*xcoord[cs+1])/3,
				(ycoord[cs]+2*ycoord[cs+1])/3,
				(2*xcoord[cs+1]+xcoord[ce])/3,
				(2*ycoord[cs+1]+ycoord[ce])/3,
				xcoord[ce], ycoord[ce]);
				fprintf(out,pfa_file);
				ncurves ++;
				break;

			case 2:
				sprintf( pfa_file, "%d %d %d %d %d %d curveto\n",
				(-xcoord[cs]+4*xcoord[cs+1])/3,
				(-ycoord[cs]+4*ycoord[cs+1])/3,
				(4*xcoord[cs+2]-xcoord[ce])/3,
				(4*ycoord[cs+2]-ycoord[ce])/3,
				xcoord[ce], ycoord[ce]);
				fprintf(out,pfa_file);
				ncurves ++;
				break;

			case 3:
				sprintf( pfa_file, "%d %d %d %d %d %d curveto\n",
				(xcoord[cs]+2*xcoord[cs+1])/3,
				(ycoord[cs]+2*ycoord[cs+1])/3,
				(5*xcoord[cs+1]+xcoord[cs+2])/6,
				(5*ycoord[cs+1]+ycoord[cs+2])/6,
				(xcoord[cs+1]+xcoord[cs+2])/2,
				(ycoord[cs+1]+ycoord[cs+2])/2);
				fprintf(out,pfa_file);
				sprintf( pfa_file, "%d %d %d %d %d %d curveto\n",
				(xcoord[cs+1]+5*xcoord[cs+2])/6,
				(ycoord[cs+1]+5*ycoord[cs+2])/6,
				(5*xcoord[cs+2]+xcoord[cs+3])/6,
				(5*ycoord[cs+2]+ycoord[cs+3])/6,
				(xcoord[cs+3]+xcoord[cs+2])/2,
				(ycoord[cs+3]+ycoord[cs+2])/2);
				fprintf(out,pfa_file);
				sprintf( pfa_file, "%d %d %d %d %d %d curveto\n",
				(xcoord[cs+2]+5*xcoord[cs+3])/6,
				(ycoord[cs+2]+5*ycoord[cs+3])/6,
				(2*xcoord[cs+3]+xcoord[ce])/3,
				(2*ycoord[cs+3]+ycoord[ce])/3,
				xcoord[ce], ycoord[ce]);
				fprintf(out,pfa_file);
				ncurves += 3;
				break;

			default:
				k1 = cs + nguide;

				sprintf( pfa_file, "%d %d %d %d %d %d curveto\n",
				(xcoord[cs]+2*xcoord[cs+1])/3,
				(ycoord[cs]+2*ycoord[cs+1])/3,
				(5*xcoord[cs+1]+xcoord[cs+2])/6,
				(5*ycoord[cs+1]+ycoord[cs+2])/6,
				(xcoord[cs+1]+xcoord[cs+2])/2,
				(ycoord[cs+1]+ycoord[cs+2])/2);
				fprintf(out,pfa_file);
				for (k = cs+2; k <= k1-1; k++)
				{
					sprintf( pfa_file, "%d %d %d %d %d %d curveto\n",
					(xcoord[k-1]+5*xcoord[k])/6,
					(ycoord[k-1]+5*ycoord[k])/6,
					(5*xcoord[k]+xcoord[k+1])/6,
					(5*ycoord[k]+ycoord[k+1])/6,
					(xcoord[k]+xcoord[k+1])/2,
					(ycoord[k]+ycoord[k+1])/2);
					fprintf(out,pfa_file);
				}
				sprintf( pfa_file, "%d %d %d %d %d %d curveto\n",
				(xcoord[k1-1]+5*xcoord[k1])/6,
				(ycoord[k1-1]+5*ycoord[k1])/6,
				(2*xcoord[k1]+xcoord[ce])/3,
				(2*ycoord[k1]+ycoord[ce])/3,
				xcoord[ce], ycoord[ce]);
				fprintf(out,pfa_file);
				ncurves += nguide;
				break;
			}
		}
		if (i >= contour_end)
		{
			fprintf(out," closepath ");
			first = 1;
			i = contour_end + 1;
			j++;
		}
		else
		{
			i++;
		}
	}
	return ncurves;
}
void finalizeTT(struct tt_info *ti)
{
FT_Error error;

	if ((error=FT_Done_FreeType(ti->ttengine)) != 0)
		FTError("Coudn't finalise FreeType engine", error);
	return;
}

int unsetFont(struct tt_info *ti)
{
	FT_Done_Face(ti->font.ttface);
}
int	setFont(struct tt_info *ti,char *file)
{
int	error;
int	i,l,total;
FT_SfntName	name;

	if ((error = FT_New_Face(ti->ttengine,file,0,&(ti->font.ttface)) != 0))
	{
		FTError("Coudn't set TrueType font", error);
	}
	total = FT_Get_Sfnt_Name_Count(ti->font.ttface);
	for (i = 0;i < total && i < 9;i++)
	{
		FT_Get_Sfnt_Name(ti->font.ttface,i,&name);
		l = (name.string_len < MAXNAME) ? name.string_len : MAXNAME;
		strncpy(ti->font.names[i],name.string,l);
		ti->font.names[i][l] = 0;
	}
	ti->font.ttheader = (TT_Header *) FT_Get_Sfnt_Table(ti->font.ttface,0);
	ti->font.ttpostscript = (TT_Postscript *) FT_Get_Sfnt_Table(ti->font.ttface,5);
	return(error);
}
#endif
