/******************************************************************************
 *  Wormux, a free clone of the game Worms from Team17.
 *  Copyright (C) 2001-2004 Lawrence Azzoug.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 ******************************************************************************
 * Math tools
 *****************************************************************************/

#ifndef MATH_TOOLS_H
#define MATH_TOOLS_H

// Limit under which, real numbers are considered as NULL
extern const double EPS_ZERO;

// Borne une valeur dans l'intervale [min;max]
long BorneLong (const long &valeur, const long &min, const long &max);
double BorneDouble (const double &valeur, const double &min, 
		    const double &max);

// Inverse un angle par rapport  l'axe vertical
double InverseAngle (const double &angle);
double InverseAngleDeg (const double &angle);

// Conversion degr en radian
double Deg2Rad (int degre);

// Valeur absolue
double AbsReel (const double x);
bool EgalZero (const double x);

#endif
