// $Id: GLView.h,v 1.5 2002/10/04 20:59:10 teuf Exp $
#ifndef WE_GLVIEW_H
#define WE_GLVIEW_H

#include <vector>

#include <gtk/gtk.h>
#include <gtkgl/gtkglarea.h>

#include <Modules/Renderer/Visual.h>

#include "../ViewWidget.h"


class GLView : public ViewWidget
{
  protected:
    GtkGLArea* m_Area;
    int m_LX, m_LY;
    int m_Width;
    int m_Height;

  public:
    GLView();
    virtual ~GLView();

   static GLView* GetView(GtkWidget* widget);

    GtkGLArea* GetArea() const { return m_Area; }
    Ark::Vector3 GetGLPos(int mx, int my) const;

    bool Expose();

    virtual bool Motion(int x, int y, int state);
    virtual bool Motion(int x, int y, int state, int lx, int ly) = 0;

    virtual bool ButtonPress(int x, int y, int button, int state) = 0;
    virtual bool ButtonRelease(int x, int y, int button, int state) = 0;

    virtual bool Render();
    virtual bool Redraw();

  protected:
    typedef std::vector< GtkGLArea* > GtkGLAreaList;
  
  private:
    void AllocArea();
    void AllocRenderer();

    static Ark::GLCache s_GLCache;
    static GtkGLAreaList s_Areas;

};

#endif // WE_GLVIEW_H
