/* lister.cc
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001 Ralf Hoffmann.
 * You can contact me at: ralf.hoffmann@epost.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: lister.cc,v 1.15 2002/04/06 22:32:36 ralf Exp $ */

#include "lister.h"
#include "worker.h"
#include "normalmode.h"
#include "locale.h"
#include "wconfig.h"

/*int max(int a,int b)
{
  return (a>b)?a:b;
}*/

Lister::Lister(Worker *tparent)
{
  AWindow *pwin=tparent->getMainWin();
  tparent->getGeometry(this,&x,&y,&w,&h);
  this->parent=tparent;
  aguix=parent->getAGUIX();
  win=new AWindow(aguix);
  win->create(pwin,x,y,w,h,0,"");
  win->show();
  lvb=(Button*)win->add(new Button(aguix,0,0,w,"","",1,1,0,0,1));
  aguix->Flush();
  activemode=NULL;
  activemodeid=-1;
  hasFocus=false;
  int j=parent->getMaxModeNr();
  modes=new ListerMode*[j];
  for(int i=0;i<j;i++) {
    modes[i]=parent->getMode4ID(i,this);
  }
}

Lister::~Lister()
{
  if(activemode!=NULL) activemode->off();
  int j=parent->getMaxModeNr();
  for(int i=0;i<j;i++) {
    delete modes[i];
  }
  delete modes;
  win->close();
  delete win;
}

void Lister::messageHandler(AGMessage *msg)
{
  bool subHandle=true;
  if(msg!=NULL) {
    switch(msg->type) {
      case AG_SIZECHANGED:
        int bh,tw,th,ty,tx;
        parent->getGeometry(this,&tx,&ty,&tw,&th);
        win->move(tx,ty);
        win->resize(tw,th);
        bh=aguix->getCharHeight()+4;
//        lvb->getSize(&bw,&bh);
        lvb->resize(tw,bh);
        this->w=tw;
        this->h=th;
        break;
      case AG_BUTTONCLICKED:
        if(msg->button.button==lvb) {
          if(msg->button.state==2) {
            configure();
          } else {
            makeActive();
          }
        }
        break;
      case AG_MOUSECLICKED:
        if(msg->mouse.window==win->getWindow()) {
          makeActive();
        }
        break;
    }
  }
  if(subHandle==true) if(activemode!=NULL) activemode->messageHandler(msg);
}

AGUIX *Lister::getAGUIX()
{
  return aguix;
}

AWindow *Lister::getAWindow()
{
  return win;
}
void Lister::setActiveMode(ListerMode *lm)
{
  activemode=lm;
}

void Lister::getGeometry(int *x2,int *y2,int *w2,int *h2)
{
  int tw,th;
  *x2=0;
  lvb->getSize(&tw,&th);
  *y2=th;
  *w2=this->w;
  *h2=this->h-th;
}

ListerMode *Lister::getActiveMode()
{
  return activemode;
}

void Lister::setFocus(bool state)
{
  int fg,bg;
  hasFocus=state;
  if(state==true) {
    fg=wconfig->getSelLVB(0);
    bg=wconfig->getSelLVB(1);
    if(activemode!=NULL) activemode->activate();
  } else {
    fg=wconfig->getUnselLVB(0);
    bg=wconfig->getUnselLVB(1);
    if(activemode!=NULL) activemode->deactivate();
  }
  lvb->setFG(0,fg);
  lvb->setBG(0,bg);
  lvb->setFG(1,fg);
  lvb->setBG(1,bg);
}

bool Lister::getFocus()
{
  return hasFocus;
}

void Lister::switch2Mode(int nr)
{
  if(activemodeid==nr) return;
  if(activemode!=NULL) activemode->off();
  int j=parent->getMaxModeNr();
  if((nr>=0)&&(nr<j)) {
    activemode=modes[nr];
    activemodeid=nr;
    modes[nr]->on();
  } else {
    activemode=NULL;
    activemodeid=-1;
  }
}

void Lister::setName(const char *str)
{
  lvb->setText(0,str);
  lvb->setText(1,str);
}

void Lister::setStatebarText(const char *str)
{
  parent->setStatebarText(str);
}

void Lister::makeActive()
{
  if(hasFocus==true) return; // Wir sind schon aktiv
  Lister *ol=parent->getOtherLister(this);
  if(ol==NULL) return; // Hoppala, da lief was schief
  ol->setFocus(false);
  setFocus(true);
}

int Lister::getSide()
{
  return parent->getSide(this);
}

bool Lister::isActive()
{
  return hasFocus;
}

void Lister::configure()
{
  int w2,h2,tw,ty,tx;
  int t1,t2;
  int nr,j,i;
  const char *cstr;
  ChooseButton **cbs;
  Button **bs;
  AWindow *win2=new AWindow(aguix);
  win2->create(NULL,10,10,10,10,0,catalog.getLocale(16));
  w2=0;
  h2=0;
  ty=5;
  Text *tt1=(Text*)win2->add(new Text(aguix,5,ty,catalog.getLocale(166),1));
  tw=tt1->getWidth()+10;
  if(tw>w2) w2=tw;
  ty+=tt1->getHeight()+5;

  nr=parent->getMaxModeNr();
  cbs=(ChooseButton**)_allocsafe(sizeof(ChooseButton*)*nr);
  bs=(Button**)_allocsafe(sizeof(Button*)*nr);
  for(i=0;i<nr;i++) {
    cbs[i]=new ChooseButton(aguix,5,ty,20,20,((modes[i]==activemode)?1:0),"",LABEL_RIGHT,0,0);
    win2->add(cbs[i]);
    tx=cbs[i]->getX()+cbs[i]->getWidth()+5;
    cstr=modes[i]->getName();
    t1=strlen(cstr)+2;
    t1*=aguix->getCharWidth();
    bs[i]=new Button(aguix,tx,ty,t1,cstr,1,0,0);
    win2->add(bs[i]);
    tw=bs[i]->getX()+bs[i]->getWidth()+10;
    if(tw>w2) w2=tw;
    ty+=a_max(cbs[i]->getHeight(),bs[i]->getHeight())+5;
  }
  t1=(strlen(catalog.getLocale(11))+2);
  t1*=aguix->getCharWidth();
  t2=(strlen(catalog.getLocale(8))+2);
  t2*=aguix->getCharWidth();
  tw=5+t1+5+t2+5;
  if(tw>w2) w2=tw;
  Button *okb=(Button*)win2->add(new Button(aguix,
                                             5,
                                             ty,
                                             t1,
                                             catalog.getLocale(11),
                                             1,
                                             0,
                                             0));
  Button *cancelb=(Button*)win2->add(new Button(aguix,
                                                 w2-5-t2,
                                                 ty,
                                                 t2,
                                                 catalog.getLocale(8),
                                                 1,
                                                 0,
                                                 0));
  h2=okb->getY()+okb->getHeight()+5;
  win2->resize(w2,h2);
  win2->setMinSize(w2,h2);
  win2->setMaxSize(w2,h2);
  win2->show();
  AGMessage *msg;
  while((msg=aguix->GetMessage(NULL))!=NULL) aguix->ReplyMessage(msg);
  int ende=0;
  while(ende==0) {
    msg=aguix->WaitMessage(win2);
    if(msg!=NULL) {
      if(msg->type==AG_CLOSEWINDOW) {
        if(msg->closewindow.window==win2->getWindow()) ende=-1;
      } else if(msg->type==AG_BUTTONCLICKED) {
        if(msg->button.button==okb) ende=1;
        else if(msg->button.button==cancelb) ende=-1;
        else {
          for(j=0;j<nr;j++) if(bs[j]==msg->button.button) break;
          if(j<nr) {
            //TODO: config modes[j]
            modes[j]->configure();
          }
        }
      } else if(msg->type==AG_KEYRELEASED) {
        if(msg->key.key==XK_Return) {
          ende=1;
        } else if(msg->key.key==XK_Escape) {
          ende=-1;
        } else {
          j=msg->key.key-XK_1;
          if((j>=0)&&(j<nr)) {
            if((msg->key.keystate&ShiftMask)==ShiftMask) {
              //TODO: config modes[j]
              modes[j]->configure();
            } else {
              for(i=0;i<nr;i++) {
                if(i!=j) cbs[i]->setState(0);
                else cbs[i]->setState((cbs[i]->getState()==0)?1:0);
              }
            }
          }
        }
      } else if(msg->type==AG_CHOOSECLICKED) {
        for(j=0;j<nr;j++) if(cbs[j]==msg->choose.button) break;
        if(j<nr) {
          for(i=0;i<nr;i++) {
            if(i!=j) cbs[i]->setState(0);
          }
        }
      }
      aguix->ReplyMessage(msg);
    }
  }
  if(ende==1) {
    // Bei OK den Mode aendern
    // TODO: Den config-Zustand uebernehmen, dazu vielleicht alle modis duplizieren und
    //       diese bearbeiten
    j=-1;
    for(i=0;i<nr;i++) {
      if(cbs[i]->getState()==1) {
        j=i;
        break;
      }
    }
    switch2Mode(j);
  }
  win2->close();
  delete win2;
  _freesafe(cbs);
  _freesafe(bs);
}

Worker *Lister::getWorker()
{
  return parent;
}

void Lister::cyclicfunc(cyclicfunc_mode_t mode)
{
  if(activemode!=NULL) activemode->cyclicfunc(mode);
}

int Lister::saveState(Datei *fh)
{
  // Ueber alle Modes: ID speichern und dann den Mode speichern ueberlassen
  int j=parent->getMaxModeNr();
  for(int i=0;i<j;i++) {
    fh->putInt(i);
    modes[i]->save(fh);
  }
  // Endsymbol
  fh->putInt(-1);
  // Jetzt muessen noch listerspezifische Dinge gespeichert werden wie aktiver Modus, selbst
  // aktiv...
  fh->putInt(Datei::getIntSize()+
             Datei::getUShortSize());
  if(activemode==NULL) {
    fh->putInt(-1);
  } else {
    fh->putInt(parent->getID4Mode(activemode));
  }
  fh->putUShort((hasFocus==true)?1:0);
  return 0;
}

int Lister::loadState(Datei *fh)
{
  int j=parent->getMaxModeNr();
  int rmode;
  do {
    rmode=fh->getInt();
    if(rmode>=0) { // Noch kein Ende
      if(rmode<j) { // Fuer diese Programmversion gueltige ModeID
        modes[rmode]->load(fh);
      } else {
        // Mode unbekannt => Chunk ueberlesen
        fh->overreadChunk();
      }
    }
  } while((rmode>=0)&&(fh->errors()==0));
  int chunksize=fh->getInt();
  if(chunksize>=(Datei::getIntSize()+
                 Datei::getUShortSize())) {
    rmode=fh->getInt();
    chunksize-=Datei::getIntSize();
    bool rhf=(fh->getUShort()==1)?true:false;
    chunksize-=Datei::getUShortSize();
    switch2Mode(rmode);
    setFocus(rhf);
  }
  while(chunksize>0) {
    fh->getUChar();
    chunksize--;
  }
  return 0;
}

void  Lister::reconfig()
{
  int fg,bg;
  if(hasFocus==true) {
    fg=wconfig->getSelLVB(0);
    bg=wconfig->getSelLVB(1);
  } else {
    fg=wconfig->getUnselLVB(0);
    bg=wconfig->getUnselLVB(1);
  }
  lvb->setFG(0,fg);
  lvb->setBG(0,bg);
  lvb->setFG(1,fg);
  lvb->setBG(1,bg);
  if(activemode!=NULL) activemode->reconfig();
}

const char *Lister::getNameOfMode(int nr)
{
  if((nr<0)||(nr>=parent->getMaxModeNr())) nr=0;
  return modes[nr]->getName();
}

bool Lister::startdnd(DNDMsg *dm)
{
  int j=parent->getMaxModeNr(),i;
  for(i=0;i<j;i++) {
    if(modes[i]->startdnd(dm)==true) break;
  }
  return (i<j)?true:false;
}

