/* dirbookmarkui.hh
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2007-2008 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef DIRBOOKMARKUI_HH
#define DIRBOOKMARKUI_HH

#include <memory>
#include <string>

#include "bookmarkdb.hh"

class DirBookmarkUI
{
public:
    DirBookmarkUI( class AGUIX &aguix, class BookmarkDB &data );
    ~DirBookmarkUI();

    int mainLoop();
    class BookmarkDBEntry getSelectedEntry();

    void setCurrentDirname( const std::string &dirname );
    void setCurrentBasename( const std::string &basename );
private:
    class AGUIX &m_aguix;
    class BookmarkDB &m_data;
    std::auto_ptr<class BookmarkDBFilter> m_filtered_data;

    std::string m_dirname, m_basename;
    
    std::auto_ptr<class AWindow> m_win;
    class FieldListView *m_lv;
    class Text *m_infixtext;
    class Button *m_okb;
    class Button *m_cancelb;
    class Button *m_addb;
    class Button *m_editb;
    class Button *m_delb;

    std::auto_ptr<class BookmarkDBEntry> m_selected_entry;

    void showData( const std::string &cat );
    class BookmarkDBEntry getActiveEntry( const std::string &cat );
};

#endif
