/*  Wordtrans, front-end for several dictionaries, for the Qt toolkit.
    Copyright (C) 2000-2004 Ricardo Villalba <rvm@escomposlinux.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "urlmanager.h"
#include "QDiccionarios.h"
#include "presentacion.h"
#include "intern.h"

#include <qglobal.h>


UrlManager::UrlManager(QDiccionarios *diccionarios, 
					   DiccionarioBase *actual,
                       QObject * parent, 
                       const char * name ) : QObject(parent,name)
{
	dicts=diccionarios;
	dict_actual=actual;
	rich_text=false;
}

UrlManager::~UrlManager() {
}

QString UrlManager::text(const QString & url, bool con_formato) {
	//qDebug("URL: '%s'", url.latin1());

	if (url == "about:null") return QString::null;

	QString nada("Not implemented yet");

	QString diccionario="";
	QString palabra;
	QString tipo;

	//Tipo
	int pos = url.find(':');
	if (pos > -1 ) {
		tipo = url.left( pos );
		palabra = url.mid( pos+1 );
#if QT_VERSION >= 300
		//Qt 3 aade "//" detrs de ":". Lo quitamos.
		if (palabra.left(2) == "//") palabra.remove(0,2);
#endif
	} else {
		palabra = url;
	}

	//Diccionario
	pos = palabra.find('@');
	if (pos > -1 ) {
		diccionario = palabra.mid( pos+1 );
		palabra = palabra.left( pos );
	}

	//qDebug("Tipo: '%s', Diccionario: '%s', Palabra: '%s'", tipo.latin1(), diccionario.latin1(), palabra.latin1() );

	//return nada;

	//ABOUT
	if ( tipo == "about" ) {
		palabra=palabra.stripWhiteSpace();

		if ( palabra == "wordtrans" ) {
			return getIntroText();
		} 
		else
		if ( palabra == "dictionary" ) {
			return getDictDesc();
		}
		else
		if ( palabra == "server" ) {
			return dict_actual->getGeneralInfo(con_formato);
		}
		else
		if ( palabra == "database" ) {
			return dict_actual->getDictionaryInfo(con_formato);
		}
		else
		if ( palabra == "broken link" ) {
			return 
				_("<h3>This is a wordtrans warning</h3>\n"
				"<p>It seems the current dictionary has found a broken link, "
				"in other words, a string starting with '<b>{</b>' but without "
				"a closing '<b>}</b>'.</p>\n"
				"<p>To be sure you can deselect the <b>Options->Rich Text</b> "
				"and see if this is true.</p>"
				"<p>If not, then you have found a bug in "
				"wordtrans. Report it to &lt;rvm@escomposlinux.org&gt; along "
				"with the text causing the problem.</p>");
		}
		else
		if ( palabra == "doc" ) {
			emit seeManual();
			return QString::null;
			//return nada; //verManual();
		}
		else
		//if ( palabra == "questions" ) {
		//	return nada; //cuestionario();
		//}
		//else
		if ( palabra == "mozilla" ) {
			return _("<p>The slowest web browser I've ever seen.</p>");
		}
		else {
			return _("<p>about what?</p><br/>"
				"<p>&lt;Insert your commercials here&gt;</p>"
				"<p>Just joking... or not? ;-)</p>");
		}
	} else 
	// HTTP
	if ( tipo == "http" ) {
#if QT_VERSION >= 300
		emit htmlLink( "http://"+palabra );
#else
		emit htmlLink( "http:"+palabra );
#endif
		return QString::null;
		//return nada; //verManual( enlace, TRUE );
	} else {
		if ( (!diccionario.isEmpty()) && (diccionario != dict_actual->getAlias()) ) {
			debug("UrlManager::text: Nuevo diccionario: %s", diccionario.latin1());
			if (!changeDict( diccionario ) ) 
				return _("Error: Unknown dictionary");
		}

		return traduce( palabra, con_formato );
	}
}


QString UrlManager::getDictDesc() {
	QString resultado;

	QStringList desc = dict_actual->getDesc();
	for (unsigned int n=0; n < desc.count(); n++) {
		QString linea = desc[n];
		resultado += linea;
		resultado += "<br>\n";
	}
	return resultado;
}

bool UrlManager::changeDict( const QString & alias ) {
	int index;
	DiccionarioBase *d= dicts->find( alias, index );
	if ((d!=NULL) && (index!=-1)) {
		dict_actual = d;
		emit dictionaryChanged( dict_actual );
		return true;
	} else
		return false;
}

QString UrlManager::traduce(const QString & palabra, bool con_formato) {
	if (dict_actual==NULL) return _("Error: No dictionary selected!");
	if (dict_actual->estaBuscando()) return _("Error: Already searching!");

	palabra.simplifyWhiteSpace();

	if (palabra.isEmpty()) return _("Error: Invalid word");

    if (dict_actual->getTipo() == DiccionarioBase::Text_dict) {
		if (palabra.length()<2) {
			return _("Error: Word too small");
        }
    }

	if (palabra.contains( "\"", FALSE)!=0 ) {
		return _("Error: Quotation marks not allowed");
	}

	QString resultado;
	bool ok = dict_actual->busca(palabra, resultado, con_formato);

	if (con_formato)
		resultado = "<qt title=\"Bsqueda\">\n" + resultado + "</qt>\n";

	emit fraseTraducida( dict_actual->getBestMatch(), palabra, 
						 resultado,
                         dict_actual->getMatches() );
	return resultado;
}

UrlManager * url_manager=NULL;

#include "urlmanager.moc.cpp"

