/*  Wordtrans, front-end for several dictionaries, for the Qt toolkit.
    Copyright (C) 2000-2004 Ricardo Villalba <rvm@escomposlinux.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "QDiccionarios.h"
#include "DiccionarioBase.h"
#include "intern.h"
#include <stdio.h>
#include <qstring.h>
#include <qstringlist.h>
#include "qfunciones.h"
#include <QConfig.h>
#include "salidas.h"
#include <qtextcodec.h>
#include "version.h"

#define BUSCAR 1
#define SHOW_DESC 2
#define SHOW_INFO_SERVER 3
#define SHOW_INFO_DICT 4

using std::strcmp;


int no_gui( int argc, char *argv[] ) {
	DiccionarioBase::no_gui = true;

	//Es necesario buscar la opcin --conf antes de crear dicts.
	QString conf_dir=QString::null;
	if (argc>0) for (int c=1;c<argc;c++) {
		//printf("%s\n", argv[c]);
		if (strcmp(argv[c],"--conf")==0) {
			if (check_arg(argc,c)) {
				conf_dir= argv[++c];
			}
		}
	}

	QDiccionarios dicts(conf_dir);
	dicts.load();

	DiccionarioBase *dict=dicts.first();

	//Lee las preferencias para seleccionar el diccionario por defecto.
	QString fullName=QConfig::configName("wordtrans/preferencias");
	//debug("Nombre config: %s", fullName);

	QConfig *conf=new QConfig(fullName.latin1());

	conf->setGroup("Appearance");
 	DiccionarioBase::color_header=conf->readEntry("table_header_color","#F8FFD2");
	DiccionarioBase::usar_tabla=conf->readBoolEntry("use_table",true);

	conf->setGroup("General");
	QString alias= conf->readEntry("diccionario", "ninguno");
	int index;
	DiccionarioBase *pref_dir=dicts.find(alias,index);
	if (pref_dir!=NULL) dict=pref_dir;


	if (dict==NULL) {
		sprintln( _("Can't find any dictionaries!"));
		exit(1);
	}

	//dict->setPalabrasCompletas(false);
	//dict->setCaseSensitive(true);
	//dict->setInvertirResultados(false);

	conf->setGroup("Encodings");
	QString charset= conf->readEntry("console", getDefaultCodecName().latin1() );
	Salidas::setCodec(charset.latin1());

	int tarea=BUSCAR;

	bool con_formato=false;
	QString palabra;

	if (argc>0) for (int c=1;c<argc;c++) {

		if (strcmp(argv[c],"--help")==0) {
			sprintln( _("wordtrans [-v] [--help] [--dicts] [--desc] [--info-server] [--info-dict]"));
            sprintln( _("          [--html] [--html-base page] [--html-link-options options]"));
			sprintln( _("          [--conf dir]"));
			sprintln( _("          [--show-charsets] [--charset codec] [--utf8] [--debug]"));
			sprintln( _("          [-d alias] [+w] [-w] [+c] [-c] [+i] [-i] [+g] [-g]"));
			sprintln( _("          [-l w_lang1 w_lang2] word"));
			sprintln( _("   -v                  display version number"));
			sprintln( _("   --help              show this helping message"));
			sprintln( _("   --dicts             show all available dictionaries"));
			sprintln( _("   --desc              show description of dictionary (in html)"));
			sprintln( _("   --info-server       show info of the dict server"));
			sprintln( _("   --info-dict         show info of a dict dictionary"));
			sprintln( _("   --html              return an html-like text"));
			sprintln( _("   --html-base page    set the base page of the web interface"));
			sprintln( _("   --html-link-options set additional options for generated links"));
			sprintln( _("   --conf dir          directory where look for configuration files"));
			sprintln( _("   --show-charsets     show all available charsets"));
			sprintln( _("   --charset codec     specify the output and input charset"));
			sprintln( _("   --utf8              same as '--charset UTF-8'"));
			sprintln( _("   --debug             shows debugging messages"));
			sprintln( _("   -d alias            select dictionary"));
			sprintln( _("   +w                  search for full words"));
			sprintln( _("   -w                  show also words which contains the selected word"));
			sprintln( _("   +c                  case sensitive"));
			sprintln( _("   -c                  no case sensitive"));
			sprintln( _("   +i                  show second language first (invert)"));
			sprintln( _("   -i                  show first language first"));
			sprintln( _("   +g                  ignore accented vowels"));
			sprintln( _("   -g                  don't ignore accented vowels"));
			sprintln( _("   -l w_lang1 w_lang2  add word in lang.1 and word in lang.2 into dictionary"));
			sprintln( _("   word                word or expression to look for"));
			exit(0);
     	}
		else
    	if (strcmp(argv[c],"-v")==0) {
			sprint( QString("Multi Language Word Translator %1 Copyright (C) 2000-2004 Ricardo Villalba\n").arg(VERSION));
			sprint( _("This program is free software; you can redistribute it and/or modify it\n"));
			sprint( _("under the terms of the GNU General Public License\n\n"));
			exit(0);
		} 
		else
    	if (strcmp(argv[c],"+w")==0) {
			dict->setPalabrasCompletas(true);
		}
		else
    	if (strcmp(argv[c],"-w")==0) {
			dict->setPalabrasCompletas(false);
		}
		else
    	if (strcmp(argv[c],"+c")==0) {
			dict->setCaseSensitive(true);
		}
		else
    	if (strcmp(argv[c],"-c")==0) {
			dict->setCaseSensitive(false);
		}
		else
    	if (strcmp(argv[c],"+i")==0) {
			dict->setInvertirResultados(true);
		}
		else
    	if (strcmp(argv[c],"-i")==0) {
			dict->setInvertirResultados(false);
		}
		else
    	if (strcmp(argv[c],"+g")==0) {
			dict->setIgnorarAcentos(true);
		}
		else
    	if (strcmp(argv[c],"-g")==0) {
			dict->setIgnorarAcentos(false);
		}
		else
    	if (strcmp(argv[c],"--dicts")==0) {
			dicts.show_dicts();
			exit(0);
		}
		else
    	if (strcmp(argv[c],"--desc")==0) {
			tarea=SHOW_DESC;
		}
		else
    	if (strcmp(argv[c],"--info-server")==0) {
			tarea=SHOW_INFO_SERVER;
		}
		else
    	if (strcmp(argv[c],"--info-dict")==0) {
			tarea=SHOW_INFO_DICT;
		}
		else
    	if (strcmp(argv[c],"--html")==0) {
			con_formato=true;
			DiccionarioBase::no_internal_links=true;
			DiccionarioBase::html_simple_header=false;
			DiccionarioBase::html_use_br=true;
		}
		else
    	if (strcmp(argv[c],"--html-base")==0) {
			if (check_arg(argc,c)) {
				QString base=argv[++c];
				DiccionarioBase::base_page=base;
			}
		}
		else
    	if (strcmp(argv[c],"--html-link-options")==0) {
			if (check_arg(argc,c)) {
				QString options=argv[++c];
				DiccionarioBase::additional_options = options;
			}
		}
		else
    	if (strcmp(argv[c],"--conf")==0) {
			//Ya procesado anteriormente. No hace nada.
			if (check_arg(argc,c)) {
				QString conf_dir=argv[++c];
			}
		}
		else
    	if (strcmp(argv[c],"--show-charsets")==0) {
			sprintln( _("Available charsets:"));
			int n=0;
			QTextCodec *codec;
			do {
				codec = QTextCodec::codecForIndex(n);
#if QT_VERSION < 300
				if (codec!=NULL) puts( codec->name() );
#else
				if (codec!=NULL) puts( codec->mimeName() );
#endif
				n++;
			} while (codec!=NULL);
			exit(0);
		}
		else
    	if (strcmp(argv[c],"--charset")==0) {
			if (check_arg(argc,c)) {
				charset=argv[++c];
				Salidas::setCodec(charset.latin1());
			}
		}
		else
		if (strcmp(argv[c],"--utf8")==0) {
			charset="UTF-8";
			Salidas::setCodec(charset.latin1());
		}
		else
    	if (strcmp(argv[c],"--debug")==0) {
			Salidas::setShowDebugMessages(true);
		}
		else
    	if (strcmp(argv[c],"--nogui")==0) {
			//Lo ignoramos
		}
		else
    	if (strcmp(argv[c],"-d")==0) {
			if (check_arg(argc,c)) {
				QString ndict=argv[++c];
				//int index;
				dict=dicts.find( ndict, index );
				if (dict==NULL) {
					sprint( _("Error: Dictionary '%1' doesn't exist\n").arg(ndict));
					exit(1);
				}
			}
		}
		else
    	if (strcmp(argv[c],"-l")==0) {
			if (check_arg(argc,c)) {
				QString lang1=QString::fromLocal8Bit( argv[++c] );
				if (check_arg(argc,c)) {
					QString lang2=QString::fromLocal8Bit( argv[++c] );
					if (dict!=NULL) {
						bool ok=dict->aprende(lang1,lang2);
						if (!ok) sprintln( _("Error: can not add new entry to dictionary"));
					}
				}
			}
			exit(0);
		}
		else
		palabra=QString::fromLocal8Bit( argv[c] );
	}


	if (!con_formato) {
		sprint( QString("wordtrans %1 Copyright (C) 2000-2004 Ricardo Villalba\n").arg(VERSION));
	}

	//BUSQUEDA
	if (tarea==BUSCAR) {
		if (palabra.isEmpty()) {
			sprintln( _("Error: you didn't tell me the word to look for."));
			sprintln( _("       I still cannot read your mind ;-)"));
			//puts( _("       who do you think I am? a fortune-teller?") );
			exit(1);
		}
		if (con_formato) 
			sprint( _("<h2>Results for '%1'</h2>\n").arg(palabra) );

		QString resultado;
		if (!dict->busca(palabra, resultado, con_formato) ) {
			sprint( _("Error: %1\n").arg(dict->getError()) );
			return 1;
		}

		if (!resultado.isEmpty() )  {
			if (con_formato) {
				sprint( 
                      _("<h3>From <a href=\"%1%2dict=%3&amp;command=show_desc\">"
                      "%4</a>:</h3>")
                      .arg(DiccionarioBase::base_page)
					  .arg(DiccionarioBase::additional_options)
                      .arg(dict->getAlias())
                      .arg(dict->getAlias()) );
			} else {
				sprint( _("From %1:\n").arg(dict->getAlias()) );
			}
			sprint(resultado);
		} else {
			sprint( _("'%1' not found\n").arg(palabra) );
		}
	} else
	//MOSTRAR DESCRIPCION DICCIONARIO
	if (tarea==SHOW_DESC) {
		if (con_formato) 
			sprint( _("<h2>About %1</h2>").arg(dict->getAlias()) );

		QStringList desc=dict->getDesc();
		for (unsigned int n=0; n < desc.count(); n++) {
			sprint( QString("%1<br>\n").arg( desc[n] ) );
        }
		//Aade unos enlaces al final si el diccionario es del
		//tipo "dict".
		if ((con_formato) && (dict->getTipo()==DiccionarioBase::Dict_dict)) {
			sprint( _("<br><br><a href=\"%1%2dict=%3&amp;command=info_server\">"
                    "Server info</a>&nbsp;&nbsp;&nbsp;&nbsp;")
					.arg( DiccionarioBase::base_page )
                    .arg(DiccionarioBase::additional_options)
                    .arg( dict->getAlias() ) );
			sprint( _("<a href=\"%1%2dict=%3&amp;command=info_dict\">"
                    "Get info about this dictionary from the server</a><br>")
                    .arg(DiccionarioBase::base_page)
                    .arg(DiccionarioBase::additional_options)
                    .arg(dict->getAlias()) );
		}
	} else
	//MOSTRAR INFORMACION DEL SERVIDOR DICT (slo diccionarios dict)
	if (tarea==SHOW_INFO_SERVER) {
		if (con_formato)
			sprint( _("<h2>Info about the dict server</h2>\n") );
		sprintln( dict->getGeneralInfo(con_formato) );
	} else
	//MOSTRAR INFORMACION DE UN DICCIONARIO DE UN SERVIDOR DICT
	if (tarea==SHOW_INFO_DICT) {
		if (con_formato)
			sprint( _("<h2>Info about the dictionary '%1'</h2>\n")
                    .arg(dict->getAlias()) );
		sprintln( dict->getDictionaryInfo(con_formato) );
	}

	if (con_formato) { 
		sprint( QString("<hr>") );
		sprint( _("Generated by ") );
		sprint( QString("wordtrans %1 Copyright (C) 2000-2004 Ricardo Villalba\n").arg(VERSION));
	}

	return 0;
}

