/*
 *  wmmisc - WindowMaker Dockapp for monitoring misc. information.
 *  Copyright (C) 2003-2004 Jesse S. (luxorfalls@sbcglobal.net)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef WMGENERAL_H_INCLUDED
#define WMGENERAL_H_INCLUDED

#define MAX_MOUSE_REGION (16)

typedef struct
{
  Pixmap pixmap;
  Pixmap mask;
  XpmAttributes attributes;
} XpmIcon;

void GetXPM (XpmIcon *, char *[]);

Pixel GetColor (char *);

int flush_expose (Window);

void RedrawWindow (void);

void RedrawWindowXY (int, int);

void AddMouseRegion (int, int, int, int, int);

int CheckMouseRegion (int, int);

void createXBMfromXPM (char *, char *[], int, int);

void copyXPMArea (int, int, unsigned int, unsigned int, int, int);

void copyXBMArea (int, int, unsigned int, unsigned int, int, int);

void setMaskXY (int, int);

void openXwindow (int, char *[], char *[], char *, int, int);

#endif /* !WMGENERAL_H_INCLUDED */
