/*
 *    wmmaiload - A dockapp to monitor mails numbers
 *    Copyright (C) 2002  Thomas Nemeth <tnemeth@free.fr>
 *
 *    Based on work by Seiichi SATO <ssato@sh.rim.or.jp>
 *    Copyright (C) 2001,2002  Seiichi SATO <ssato@sh.rim.or.jp>
 *    and on work by Mark Staggs <me@markstaggs.net>
 *    Copyright (C) 2002  Mark Staggs <me@markstaggs.net>
 
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */


#ifndef MAIN_H
#define MAIN_H

#include <utime.h>
#include <time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "dockapp.h"


#define SET_STRING(str, val) {if (str) free(str); str = xstrdup(val);}

#define DEFAULT_CFGFILE ".wmmailoadrc"
#define SIZE            58
#define MAXSTRLEN       512
#define WINDOWED_BG     ". c #AEAAAE"
#define MAX_HISTORY     16
#define CPUNUM_NONE     -1

#define MTIME 1
#define ATIME 2
#define CTIME 3


typedef enum { LIGHTOFF = 0, LIGHTON } light;
typedef enum { NOALARM = 0, NEWGLOB, NEWHERE, NEWBOTH } MailAlarm;
typedef enum { MBOX, MAILDIR, MH, POP3, HOTMAIL, IMAP } BoxType;

typedef struct MailBox
{
        char*           entry;
        time_t          time;
        off_t           size;
        int             new;
        int             total;
        int             updated;
        int             changed;
        int             in_thread;
        BoxType         type;
        char*           username;
        char*           password;
        char*           folder;
        int             port;
        struct MailBox* next;
}
MailBox;

MailBox * get_mailbox(int box_num);
Bool fexist(const char *filename);
Bool filetime(const char *filename, time_t *time, int mode);
Bool filesize(const char *filename, off_t *fsize);
Bool load_cfgfile(Bool wait);


#endif /* MAIN_H */

