/***************************************************************************
 *   Copyright (C) 2005 by Pawel Nawrocki                                  *
 *   pnawrocki@interia.pl                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include "wlassistant.h"

#include <kapplication.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <klocale.h>

static const char description[] =
        I18N_NOOP("Wireless Assistant");

static const char version[] = "0.5.5";

static KCmdLineOptions options[] =
        {
                //    { "+[URL]", I18N_NOOP( "Document to open" ), 0 },
                KCmdLineLastOption
        };

int main(int argc, char **argv)
{
        KAboutData about("wlassistant", I18N_NOOP("Wireless Assistant"), version, description,
                         KAboutData::License_GPL, "(C) %{YEAR} Pawel Nawrocki", 0, 0, "pnawrocki@interia.pl");
        about.addAuthor( "Pawel Nawrocki", 0, "pnawrocki@interia.pl" );
        KCmdLineArgs::init(argc, argv, &about);
        KCmdLineArgs::addCmdLineOptions( options );
        KApplication app;
        WirelessAssistant *mainWin = 0;
                mainWin = new WirelessAssistant();
                mainWin->setCaption( QString("%1 %2").arg(description).arg(version) );
                app.setMainWidget( mainWin );
                mainWin->show();

        // mainWin has WDestructiveClose flag by default, so it will delete itself.
        return app.exec();
}
