/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Paint;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.CropImageFilter;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderContext;
import java.awt.image.renderable.RenderableImage;
import java.io.IOException;
import java.text.AttributedCharacterIterator;
import java.util.Arrays;
import java.util.Map;
import org.freehep.graphics2d.font.FontEncoder;
import org.freehep.graphicsio.MultiPageDocument;
import org.freehep.graphicsio.VectorGraphicsIO;
import org.freehep.util.images.ImageUtilities;

public abstract class AbstractVectorGraphicsIO
extends VectorGraphicsIO {
    private static final String rootKey = AbstractVectorGraphicsIO.class.getName();
    public static final String EMIT_WARNINGS = rootKey + ".EMIT_WARNINGS";
    public static final String TEXT_AS_SHAPES = rootKey + ".TEXT_AS_SHAPES";
    public static final String EMIT_ERRORS = rootKey + ".EMIT_ERRORS";
    public static final String CLIP = rootKey + ".CLIP";
    private Dimension size;
    private Component component;
    private boolean doRestoreOnDispose;
    private Rectangle deviceClip;
    private Area userClip;
    private AffineTransform currentTransform;
    private AffineTransform oldTransform = new AffineTransform();
    private Composite currentComposite;
    private Stroke currentStroke;
    private RenderingHints hints;

    protected AbstractVectorGraphicsIO(Dimension dimension, boolean bl2) {
        this.size = dimension;
        this.component = null;
        this.doRestoreOnDispose = bl2;
        this.deviceClip = dimension != null ? new Rectangle(0, 0, dimension.width, dimension.height) : null;
        this.userClip = null;
        this.currentTransform = new AffineTransform();
        this.currentComposite = AlphaComposite.getInstance(3);
        this.currentStroke = new BasicStroke(1.0f, 2, 0, 10.0f, null, 0.0f);
        super.setColor(Color.BLACK);
        super.setBackground(Color.BLACK);
        super.setFont(new Font("Dialog", 0, 12));
        this.hints = new RenderingHints(null);
    }

    protected AbstractVectorGraphicsIO(Component component, boolean bl2) {
        this.size = component.getSize();
        this.component = component;
        this.doRestoreOnDispose = bl2;
        this.deviceClip = this.size != null ? new Rectangle(0, 0, this.size.width, this.size.height) : null;
        this.userClip = null;
        GraphicsConfiguration graphicsConfiguration = component.getGraphicsConfiguration();
        this.currentTransform = graphicsConfiguration != null ? graphicsConfiguration.getDefaultTransform() : new AffineTransform();
        this.currentComposite = AlphaComposite.getInstance(3);
        this.currentStroke = new BasicStroke(1.0f, 2, 0, 10.0f, null, 0.0f);
        super.setFont(component.getFont());
        super.setBackground(component.getBackground());
        super.setColor(component.getForeground());
        this.hints = new RenderingHints(null);
    }

    protected AbstractVectorGraphicsIO(AbstractVectorGraphicsIO abstractVectorGraphicsIO, boolean bl2) {
        super(abstractVectorGraphicsIO);
        this.doRestoreOnDispose = bl2;
        this.size = new Dimension(abstractVectorGraphicsIO.size);
        this.component = abstractVectorGraphicsIO.component;
        this.deviceClip = new Rectangle(abstractVectorGraphicsIO.deviceClip);
        this.userClip = abstractVectorGraphicsIO.userClip != null ? new Area(abstractVectorGraphicsIO.userClip) : null;
        this.currentTransform = new AffineTransform(abstractVectorGraphicsIO.currentTransform);
        this.currentComposite = abstractVectorGraphicsIO.currentComposite;
        this.currentStroke = abstractVectorGraphicsIO.currentStroke;
        this.hints = abstractVectorGraphicsIO.hints;
    }

    public Dimension getSize() {
        return this.size;
    }

    public Component getComponent() {
        return this.component;
    }

    public void startExport() {
        try {
            this.writeHeader();
            if (!(this instanceof MultiPageDocument)) {
                this.writeGraphicsState();
                this.writeBackground();
            }
        }
        catch (IOException iOException) {
            this.handleException(iOException);
        }
    }

    public void endExport() {
        try {
            this.dispose();
            this.writeTrailer();
            this.closeStream();
        }
        catch (IOException iOException) {
            this.handleException(iOException);
        }
    }

    public abstract void writeHeader() throws IOException;

    public void writeGraphicsState() throws IOException {
        this.writePaint(this.getPrintColor(this.getColor()));
        this.writeSetTransform(this.getTransform());
        this.setClip(this.getClip());
    }

    public abstract void writeBackground() throws IOException;

    public abstract void writeTrailer() throws IOException;

    public abstract void closeStream() throws IOException;

    public void printComment(String string) {
        try {
            this.writeComment(string);
        }
        catch (IOException iOException) {
            this.handleException(iOException);
        }
    }

    public abstract void writeComment(String var1) throws IOException;

    protected void resetClip(Rectangle rectangle) {
        this.deviceClip = rectangle;
        this.userClip = null;
    }

    public void dispose() {
        try {
            if (this.doRestoreOnDispose) {
                this.writeGraphicsRestore();
                this.doRestoreOnDispose = false;
            }
        }
        catch (IOException iOException) {
            this.handleException(iOException);
        }
    }

    protected abstract void writeGraphicsSave() throws IOException;

    protected abstract void writeGraphicsRestore() throws IOException;

    public boolean drawImage(Image image, int n2, int n3, ImageObserver imageObserver) {
        int n4 = image.getWidth(imageObserver);
        int n5 = image.getHeight(imageObserver);
        return this.drawImage(image, n2, n3, n2 + n4, n3 + n5, 0, 0, n4, n5, null, imageObserver);
    }

    public boolean drawImage(Image image, int n2, int n3, int n4, int n5, ImageObserver imageObserver) {
        int n6 = image.getWidth(imageObserver);
        int n7 = image.getHeight(imageObserver);
        return this.drawImage(image, n2, n3, n2 + n4, n3 + n5, 0, 0, n6, n7, null, imageObserver);
    }

    public boolean drawImage(Image image, int n2, int n3, int n4, int n5, Color color, ImageObserver imageObserver) {
        int n6 = image.getWidth(imageObserver);
        int n7 = image.getHeight(imageObserver);
        return this.drawImage(image, n2, n3, n2 + n4, n3 + n5, 0, 0, n6, n7, color, imageObserver);
    }

    public boolean drawImage(Image image, int n2, int n3, Color color, ImageObserver imageObserver) {
        int n4 = image.getWidth(imageObserver);
        int n5 = image.getHeight(imageObserver);
        return this.drawImage(image, n2, n3, n2 + n4, n3 + n5, 0, 0, n4, n5, color, imageObserver);
    }

    public boolean drawImage(Image image, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, ImageObserver imageObserver) {
        return this.drawImage(image, n2, n3, n4, n5, n6, n7, n8, n9, null, imageObserver);
    }

    public boolean drawImage(Image image, AffineTransform affineTransform, ImageObserver imageObserver) {
        this.drawRenderedImage(ImageUtilities.createRenderedImage(image, imageObserver, null), affineTransform);
        return true;
    }

    public void drawImage(BufferedImage bufferedImage, BufferedImageOp bufferedImageOp, int n2, int n3) {
        this.drawImage((Image)bufferedImageOp.filter(bufferedImage, null), n2, n3, null);
    }

    public void drawRenderableImage(RenderableImage renderableImage, AffineTransform affineTransform) {
        this.drawRenderedImage(renderableImage.createRendering(new RenderContext(new AffineTransform(), this.getRenderingHints())), affineTransform);
    }

    public boolean drawImage(Image image, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, Color color, ImageObserver imageObserver) {
        try {
            int n10 = Math.min(n6, n8);
            int n11 = Math.min(n7, n9);
            int n12 = Math.abs(n8 - n6);
            int n13 = Math.abs(n9 - n7);
            int n14 = Math.abs(n4 - n2);
            int n15 = Math.abs(n5 - n3);
            if (n10 != 0 || n11 != 0 || n12 != image.getWidth(imageObserver) || n13 != image.getHeight(imageObserver)) {
                CropImageFilter cropImageFilter = new CropImageFilter(n10, n11, n12, n13);
                image = Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(image.getSource(), cropImageFilter));
                MediaTracker mediaTracker = new MediaTracker(new Panel());
                mediaTracker.addImage(image, 0);
                try {
                    mediaTracker.waitForAll();
                }
                catch (InterruptedException interruptedException) {
                    this.handleException(interruptedException);
                }
            }
            boolean bl2 = n4 < n2 ^ n8 < n6;
            boolean bl3 = n5 < n3 ^ n9 < n7;
            double d2 = bl2 ? (double)n4 : (double)n2;
            double d3 = bl3 ? (double)n5 : (double)n3;
            double d4 = (double)n14 / (double)n12;
            d4 = bl2 ? -1.0 * d4 : d4;
            double d5 = (double)n15 / (double)n13;
            d5 = bl3 ? -1.0 * d5 : d5;
            this.writeImage(ImageUtilities.createRenderedImage(image, imageObserver, color), new AffineTransform(d4, 0.0, 0.0, d5, d2, d3), color);
            return true;
        }
        catch (IOException iOException) {
            this.handleException(iOException);
            return false;
        }
    }

    public void drawRenderedImage(RenderedImage renderedImage, AffineTransform affineTransform) {
        try {
            this.writeImage(renderedImage, affineTransform, null);
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
    }

    protected abstract void writeImage(RenderedImage var1, AffineTransform var2, Color var3) throws IOException;

    public void clearRect(double d2, double d3, double d4, double d5) {
        Paint paint = this.getPaint();
        this.setPaint(this.getBackground());
        this.fillRect(d2, d3, d4, d5);
        this.setPaint(paint);
    }

    public void drawString(String string, double d2, double d3) {
        if (string == null || string.equals("")) {
            return;
        }
        if (this.isProperty(TEXT_AS_SHAPES)) {
            Font font = this.getFont();
            String string2 = font.getName();
            if (string2.equals("Symbol") || string2.equals("ZapfDingbats")) {
                string = FontEncoder.getEncodedString(string, string2);
                font = new Font("Serif", font.getStyle(), font.getSize());
            }
            GlyphVector glyphVector = font.createGlyphVector(this.getFontRenderContext(), string);
            this.drawGlyphVector(glyphVector, (float)d2, (float)d3);
        } else {
            try {
                this.writeString(string, d2, d3);
            }
            catch (IOException iOException) {
                this.handleException(iOException);
            }
        }
    }

    protected abstract void writeString(String var1, double var2, double var4) throws IOException;

    public void drawGlyphVector(GlyphVector glyphVector, float f2, float f3) {
        this.fill(glyphVector.getOutline(f2, f3));
    }

    public void drawString(AttributedCharacterIterator attributedCharacterIterator, float f2, float f3) {
        if (this.isProperty(TEXT_AS_SHAPES)) {
            TextLayout textLayout = new TextLayout(attributedCharacterIterator, this.getFontRenderContext());
            textLayout.draw(this, f2, f3);
        } else {
            Font font = this.getFont();
            Map<AttributedCharacterIterator.Attribute, Object> map = font.getAttributes();
            StringBuffer stringBuffer = new StringBuffer();
            char c2 = attributedCharacterIterator.first();
            while (c2 != '\uffff') {
                if (((Object)map).equals(attributedCharacterIterator.getAttributes())) {
                    stringBuffer.append(c2);
                } else {
                    this.drawString(stringBuffer.toString(), f2, f3);
                    TextLayout textLayout = new TextLayout(stringBuffer.toString(), map, this.getFontRenderContext());
                    f2 += Math.max(textLayout.getAdvance(), (float)textLayout.getBounds().getWidth());
                    stringBuffer = new StringBuffer();
                    stringBuffer.append(c2);
                    map = attributedCharacterIterator.getAttributes();
                    this.setFont(new Font(map));
                }
                c2 = attributedCharacterIterator.next();
            }
            if (stringBuffer.length() > 0) {
                this.drawString(stringBuffer.toString(), f2, f3);
            }
            this.setFont(font);
        }
    }

    public AffineTransform getTransform() {
        return new AffineTransform(this.currentTransform);
    }

    public void setTransform(AffineTransform affineTransform) {
        this.oldTransform.setTransform(this.currentTransform);
        this.currentTransform.setTransform(affineTransform);
        try {
            this.writeSetTransform(affineTransform);
        }
        catch (IOException iOException) {
            this.handleException(iOException);
        }
    }

    public void transform(AffineTransform affineTransform) {
        this.currentTransform.concatenate(affineTransform);
        try {
            this.writeTransform(affineTransform);
        }
        catch (IOException iOException) {
            this.handleException(iOException);
        }
    }

    public void translate(double d2, double d3) {
        this.currentTransform.translate(d2, d3);
        try {
            this.writeTransform(new AffineTransform(1.0, 0.0, 0.0, 1.0, d2, d3));
        }
        catch (IOException iOException) {
            this.handleException(iOException);
        }
    }

    public void rotate(double d2) {
        this.currentTransform.rotate(d2);
        try {
            this.writeTransform(new AffineTransform(Math.cos(d2), Math.sin(d2), -Math.sin(d2), Math.cos(d2), 0.0, 0.0));
        }
        catch (IOException iOException) {
            this.handleException(iOException);
        }
    }

    public void scale(double d2, double d3) {
        this.currentTransform.scale(d2, d3);
        try {
            this.writeTransform(new AffineTransform(d2, 0.0, 0.0, d3, 0.0, 0.0));
        }
        catch (IOException iOException) {
            this.handleException(iOException);
        }
    }

    public void shear(double d2, double d3) {
        this.currentTransform.shear(d2, d3);
        try {
            this.writeTransform(new AffineTransform(1.0, d3, d2, 1.0, 0.0, 0.0));
        }
        catch (IOException iOException) {
            this.handleException(iOException);
        }
    }

    protected abstract void writeTransform(AffineTransform var1) throws IOException;

    protected void writeSetTransform(AffineTransform affineTransform) throws IOException {
        try {
            AffineTransform affineTransform2 = new AffineTransform(affineTransform);
            affineTransform.concatenate(this.oldTransform.createInverse());
            this.writeTransform(affineTransform2);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            // empty catch block
        }
    }

    public Shape getClip() {
        return this.userClip != null ? new Area(this.untransformShape(this.userClip)) : null;
    }

    public Rectangle getClipBounds() {
        Shape shape = this.getClip();
        return shape != null ? this.getClip().getBounds() : null;
    }

    public Rectangle getClipBounds(Rectangle rectangle) {
        Rectangle rectangle2 = this.getClipBounds();
        if (rectangle2 != null) {
            rectangle.setBounds(rectangle2);
        }
        return rectangle;
    }

    public void clipRect(int n2, int n3, int n4, int n5) {
        this.clip(new Rectangle(n2, n3, n4, n5));
    }

    public void clipRect(double d2, double d3, double d4, double d5) {
        this.clip(new Rectangle2D.Double(d2, d3, d4, d5));
    }

    public void setClip(int n2, int n3, int n4, int n5) {
        this.setClip(new Rectangle(n2, n3, n4, n5));
    }

    public void setClip(double d2, double d3, double d4, double d5) {
        this.setClip(new Rectangle2D.Double(d2, d3, d4, d5));
    }

    public void setClip(Shape shape) {
        Shape shape2 = this.transformShape(shape);
        this.userClip = shape2 != null ? new Area(shape2) : null;
        try {
            this.writeSetClip(shape);
        }
        catch (IOException iOException) {
            this.handleException(iOException);
        }
    }

    public void clip(Shape shape) {
        Shape shape2 = this.transformShape(shape);
        if (this.userClip != null) {
            if (shape2 != null) {
                this.userClip.intersect(new Area(shape2));
            } else {
                this.userClip = null;
            }
        } else {
            this.userClip = shape2 != null ? new Area(shape2) : null;
        }
        try {
            this.writeClip(shape);
        }
        catch (IOException iOException) {
            this.handleException(iOException);
        }
    }

    protected abstract void writeClip(Shape var1) throws IOException;

    protected abstract void writeSetClip(Shape var1) throws IOException;

    public Stroke getStroke() {
        return this.currentStroke;
    }

    public void setStroke(Stroke stroke) {
        if (stroke.equals(this.currentStroke)) {
            return;
        }
        try {
            this.writeStroke(stroke);
        }
        catch (IOException iOException) {
            this.handleException(iOException);
        }
        this.currentStroke = stroke;
    }

    protected void writeStroke(Stroke stroke) throws IOException {
        if (stroke instanceof BasicStroke) {
            float f2;
            int n2;
            int n3;
            float f3;
            BasicStroke basicStroke = (BasicStroke)stroke;
            int n4 = -1;
            int n5 = -1;
            float f4 = -1.0f;
            float f5 = -1.0f;
            float f6 = -1.0f;
            float[] fArray = null;
            if (this.currentStroke != null && this.currentStroke instanceof BasicStroke) {
                BasicStroke basicStroke2 = (BasicStroke)this.currentStroke;
                n4 = basicStroke2.getEndCap();
                n5 = basicStroke2.getLineJoin();
                f4 = basicStroke2.getLineWidth();
                f5 = basicStroke2.getMiterLimit();
                fArray = basicStroke2.getDashArray();
                f6 = basicStroke2.getDashPhase();
            }
            if (f4 != (f3 = basicStroke.getLineWidth())) {
                this.writeWidth(f3);
            }
            if (n4 != (n3 = basicStroke.getEndCap())) {
                this.writeCap(n3);
            }
            if (n5 != (n2 = basicStroke.getLineJoin())) {
                this.writeJoin(n2);
            }
            if (f5 != (f2 = basicStroke.getMiterLimit()) && f2 >= 1.0f) {
                this.writeMiterLimit(f2);
            }
            if (!Arrays.equals(fArray, basicStroke.getDashArray()) || f6 != basicStroke.getDashPhase()) {
                if (basicStroke.getDashArray() != null) {
                    this.writeDash(basicStroke.getDashArray(), basicStroke.getDashPhase());
                } else {
                    this.writeDash(new float[0], basicStroke.getDashPhase());
                }
            }
        }
    }

    protected void writeWidth(float f2) throws IOException {
        this.writeWarning(this.getClass() + ": writeWidth() not implemented.");
    }

    protected void writeCap(int n2) throws IOException {
        this.writeWarning(this.getClass() + ": writeCap() not implemented.");
    }

    protected void writeJoin(int n2) throws IOException {
        this.writeWarning(this.getClass() + ": writeJoin() not implemented.");
    }

    protected void writeMiterLimit(float f2) throws IOException {
        this.writeWarning(this.getClass() + ": writeMiterLimit() not implemented.");
    }

    protected void writeDash(float[] fArray, float f2) throws IOException {
        double[] dArray = new double[fArray.length];
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            dArray[i2] = fArray[i2];
        }
        this.writeDash(dArray, (double)f2);
    }

    protected void writeDash(double[] dArray, double d2) throws IOException {
        this.writeWarning(this.getClass() + ": writeDash() not implemented.");
    }

    public void setColor(Color color) {
        if (color == null) {
            return;
        }
        if (color.equals(this.getColor())) {
            return;
        }
        try {
            super.setColor(color);
            this.writePaint(this.getPrintColor(color));
        }
        catch (IOException iOException) {
            this.handleException(iOException);
        }
    }

    public void setPaint(Paint paint) {
        if (paint == null) {
            return;
        }
        if (paint.equals(this.getPaint())) {
            return;
        }
        try {
            if (paint instanceof Color) {
                this.setColor((Color)paint);
            } else if (paint instanceof GradientPaint) {
                super.setPaint(paint);
                this.writePaint((GradientPaint)paint);
            } else if (paint instanceof TexturePaint) {
                super.setPaint(paint);
                this.writePaint((TexturePaint)paint);
            } else {
                super.setPaint(paint);
                this.writePaint(paint);
            }
        }
        catch (IOException iOException) {
            this.handleException(iOException);
        }
    }

    protected abstract void writePaint(Color var1) throws IOException;

    protected abstract void writePaint(GradientPaint var1) throws IOException;

    protected abstract void writePaint(TexturePaint var1) throws IOException;

    protected abstract void writePaint(Paint var1) throws IOException;

    public FontRenderContext getFontRenderContext() {
        return new FontRenderContext(new AffineTransform(1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f), true, true);
    }

    public FontMetrics getFontMetrics(Font font) {
        return Toolkit.getDefaultToolkit().getFontMetrics(font);
    }

    public RenderingHints getRenderingHints() {
        return (RenderingHints)this.hints.clone();
    }

    public void addRenderingHints(Map map) {
        map.putAll(map);
    }

    public void setRenderingHints(Map map) {
        map.clear();
        map.putAll(map);
    }

    public Object getRenderingHint(RenderingHints.Key key) {
        return this.hints.get(key);
    }

    public void setRenderingHint(RenderingHints.Key key, Object object) {
        if (key == null || object == null) {
            return;
        }
        this.hints.put(key, object);
    }

    public void setFont(Font font) {
        if (font == null) {
            return;
        }
        super.setFont(font);
        try {
            this.writeFont(font);
        }
        catch (IOException iOException) {
            this.handleException(iOException);
        }
    }

    protected abstract void writeFont(Font var1) throws IOException;

    public Composite getComposite() {
        return this.currentComposite;
    }

    public void setComposite(Composite composite) {
        this.currentComposite = composite;
    }

    protected void handleException(Exception exception) {
        if (exception instanceof UnsupportedOperationException) {
            this.writeWarning(exception);
        } else {
            this.writeError(exception);
        }
    }

    protected void writeWarning(Exception exception) {
        this.writeWarning(exception.getMessage());
    }

    protected void writeWarning(String string) {
        if (this.isProperty(EMIT_WARNINGS)) {
            System.err.println(string);
        }
    }

    protected void writeError(Exception exception) {
        throw new RuntimeException(exception);
    }

    protected Shape createShape(double[] dArray, double[] dArray2, int n2, boolean bl2) {
        GeneralPath generalPath = new GeneralPath(0);
        if (n2 > 0) {
            generalPath.moveTo((float)dArray[0], (float)dArray2[0]);
            for (int i2 = 1; i2 < n2; ++i2) {
                generalPath.lineTo((float)dArray[i2], (float)dArray2[i2]);
            }
            if (bl2) {
                generalPath.closePath();
            }
        }
        return generalPath;
    }

    private Shape transformShape(AffineTransform affineTransform, Shape shape) {
        if (shape == null) {
            return null;
        }
        return affineTransform.createTransformedShape(shape);
    }

    private Shape transformShape(Shape shape) {
        return this.transformShape(this.getTransform(), shape);
    }

    private Shape untransformShape(Shape shape) {
        if (shape == null) {
            return null;
        }
        try {
            return this.transformShape(this.getTransform().createInverse(), shape);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            return null;
        }
    }

    protected void overLine(String string, Font font, float f2, float f3) {
        TextLayout textLayout = new TextLayout(string, font, this.getFontRenderContext());
        float f4 = Math.max(textLayout.getAdvance(), (float)textLayout.getBounds().getWidth());
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(f2, f3 + (float)textLayout.getBounds().getY() - textLayout.getAscent());
        generalPath.lineTo(f2 + f4, f3 + (float)textLayout.getBounds().getY() - textLayout.getAscent() - textLayout.getAscent());
        this.draw(generalPath);
    }
}

