/*
 * Decompiled with CFR 0.152.
 */
package SharpTools;

import SharpTools.CellPoint;
import SharpTools.Function;
import SharpTools.Node;
import SharpTools.ParserException;
import SharpTools.SharpTableModel;
import SharpTools.SharpTools;
import java.util.LinkedList;

class FunctionCount
extends Function {
    FunctionCount() {
    }

    public Number evaluate(SharpTableModel table, Node node, int row, int col) throws ParserException {
        this.checkParamsExist(node);
        int count = 0;
        LinkedList params = node.getParams();
        if (params != null) {
            for (Node exp : params) {
                if (this.isRange(exp)) {
                    CellPoint[] addr = this.getFirst(exp).getAddressRange(row, col);
                    count += (addr[1].getRow() - addr[0].getRow() + 1) * (addr[1].getCol() - addr[0].getCol() + 1);
                    continue;
                }
                ++count;
            }
        }
        return new Integer(count);
    }

    public String getUsage() {
        return "COUNT(value1,value2,...)";
    }

    public String getDescription() {
        return SharpTools.translation.getProperty("count_desc");
    }
}

