/*
  libwftk - Worldforge Toolkit - a widget library
  Copyright (C) 2002 Malcolm Walker <malcolm@worldforge.org>
  Based on code copyright  (C) 1999-2002  Karsten Laux

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.
  
  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA  02111-1307, SA.
*/

#ifndef _POINT_H
#define _POINT_H

#include <iosfwd>

namespace wftk {

/// Class to handle x,y - points on the screen
class Point
{
 public:
  /// Construct a point at (0, 0)
  Point() : x(0), y(0) {}
  /// Construct a point
  Point(int x_, int y_) : x(x_), y(y_) {}
  /// Shift a point
  Point& operator+=(const Point& p)                             
    {  x += p.x; y += p.y;  return *this; }
  /// Shift a point
  Point& operator-=(const Point& p)                             
    {  x -= p.x; y -= p.y;  return *this; }
#ifndef WFTK_DISABLE_DEPRECATED
  ///
  ~Point() {};
#endif
  /// Return a shifted point
  friend Point operator+(const Point& p, const Point& q)
    { return Point(p) += q; }
  /// Return a shifted point
  friend Point operator-(const Point& p, const Point& q)
    { return Point(p) -= q; }   
  /// return the negative of a point
  Point operator-() const {return Point(-x, -y);}
  /// Compare two points
  friend bool operator==(const Point &p, const Point &q)
    { return (p.x == q.x) && (p.y == q.y); }
  /// Compare two points
  friend bool operator!=(const Point &p, const Point &q)
    { return (p.x != q.x) || (p.y != q.y); }
  /// for std::map only
  friend bool operator<(const Point &p, const Point &q)
    { return p.x < q.x || (p.x == q.x && p.y < q.y); }
  /// Print a point to a stream
  friend std::ostream& operator<<(std::ostream& s, const Point& p);
  /// The point's x coordinate
  int x;
  /// The point's y coordinate
  int y;

};

} // namespace wftk

#endif // _POINT_H
