#!/usr/local/bin/ruby

$:.unshift('../../lib')

require 'webrick/https'
require 'getopts'

getopts nil, 'r:'

dir = File::dirname(File::expand_path(__FILE__))

pkey = cert = cert_name = nil
begin
  data = open(dir + "/conf/sample.key"){|io| io.read }
  pkey = OpenSSL::PKey::RSA.new(data)
  data = open(dir + "/conf/sample.crt"){|io| io.read }
  cert = OpenSSL::X509::Certificate.new(data)
rescue
  $stderr.puts "Switching to use self-signed certificate"
  cert_name = [ ["C","JP"], ["O","WEBrick.Org"], ["CN", "WWW"] ]
end

s=WEBrick::HTTPServer.new(
  :BindAddress      => "0.0.0.0",
  :Port             => 2000,
  :Logger           => WEBrick::Log::new($stderr, WEBrick::Log::DEBUG),
  :DocumentRoot     => $OPT_r || dir + "/htdocs",
  :SSLEnable        => true,
  :SSLVerifyClient  => ::OpenSSL::SSL::VERIFY_NONE,
  :SSLCertificate   => cert,
  :SSLPrivateKey    => pkey,
  :SSLCertName      => cert_name
)
trap("INT"){ s.shutdown }
s.start
