#!/usr/local/bin/perl
# edit_mods.cgi
# Form for installing and removing modules

require './webmin-lib.pl';
&header($text{'mods_title'}, "");
print "<hr>\n";
%access = &get_module_acl();

opendir(DIR, "..");
foreach $m (readdir(DIR)) {
	local %minfo;
	if ((%minfo = &get_module_info($m)) && &check_os_support(\%minfo)) {
		push(@mlist, \%minfo);
		}
	}
closedir(DIR);
@mlist = sort { $a->{'desc'} cmp $b->{'desc'} } @mlist;

# Display installation form
print "<table width=100%><tr><td valign=top>\n";
print "$text{'mods_desc1'}</td><td valign=top>";

print "<form action=install_mod.cgi enctype=multipart/form-data method=post>\n";
print "<table border>\n";
print "<tr $tb> <td><b>$text{'mods_install'}</b></td> </tr>\n";
print "<tr $cb> <td>\n";
print "<input type=radio name=source value=0 checked> $text{'mods_local'}\n";
print "<input name=file size=40>\n";
print &file_chooser_button("file", 0),"<br>\n";
print "<input type=radio name=source value=1> $text{'mods_uploaded'}\n";
print "<input name=upload type=file size=30><br>\n";
print "<input type=radio name=source value=2> $text{'mods_ftp'}\n";
print "<input name=url size=40><br>\n";
print "&nbsp;" x 5;
print "<input type=checkbox name=nodeps value=1> $text{'mods_nodeps'}<br>\n";
print "</td></tr></table><br>\n";
print "<input type=submit value=\"$text{'mods_installok'}\">\n";
print "</form></td></tr></table> <hr>\n";

if (!$access{'install'}) {
	# Display cloning form
	print "<table width=100%><tr><td valign=top>\n";
	print "$text{'mods_desc2'}</td> <td valign=top>";

	print "<form action=clone_mod.cgi>\n";
	print "<table border>\n";
	print "<tr $tb> <td><b>$text{'mods_clone'}</b></td> </tr>\n";
	print "<tr $cb> <td><table>\n";
	print "<tr> <td><b>$text{'mods_cname'}</b></td>\n";
	print "<td><select name=mod>\n";
	foreach $m (@mlist) {
		if ($m->{'dir'} ne 'webmin' && !$m->{'clone'}) {
			printf "<option value='%s'>%s\n",
				$m->{'dir'}, $m->{'desc'};
			}
		}
	closedir(DIR);
	print "</select></td> </tr>\n";
	print "<tr> <td><b>$text{'mods_cnew'}</b></td>\n";
	print "<td><input name=desc size=30></td> </tr>\n";
	print "</table></td></tr> </table><br>\n";
	print "<input type=submit value=\"$text{'mods_cloneok'}\">\n";
	print "</form></td></tr></table> <hr>\n";


	# Display deletion form
	print "<table width=100%><tr>\n";
	print "<td valign=top>$text{'mods_desc3'}</td> <td>\n";
	print "<form action=delete_mod.cgi>\n";
	print "<table border width=100%>\n";
	print "<tr $tb> <td valign=top><b>$text{'mods_delete'}</b></td> </tr>\n";
	print "<tr> <td $cb><select multiple width=300 name=mod size=10>\n";
	$version = &get_webmin_version();
	local $home = $ENV{'SERVER_ROOT'} eq '/usr/local/webadmin';
	foreach $m (@mlist) {
		if ($m->{'dir'} ne 'webmin' && &check_os_support($m)) {
			local @st = stat("../$m->{'dir'}");
			local @tm = localtime($st[9]);
			local $vstr = $m->{'version'} == $version ? "" :
				      $m->{'version'} ? "(v. $m->{'version'})" :
				      $home ? "" :
				      sprintf "(%d/%d/%d)",
					      $tm[3], $tm[4]+1, $tm[5]+1900;
			printf "<option value='%s'>%s %s\n",
				$m->{'dir'}, $m->{'desc'}, $vstr;
			}
		}
	print "</select></td> </tr></table>\n";
	print "<input type=submit value=\"$text{'mods_deleteok'}\">\n";
	print "</form></td></tr></table>\n";
	print "<hr>\n";
	}

&footer("", $text{'index_return'});

