#!/usr/local/bin/perl
# view_man.cgi
# Display a single manual page

require './man-lib.pl';
&ReadParse();
&header($text{'man_title'}, "");
print "<hr>\n";

if (&has_command($config{'man2html_path'})) {
	$cmd = $in{'sec'} ? $config{'list_cmd_sect'}
			  : $config{'list_cmd'};
	}
else {
	$cmd = $in{'sec'} ? $config{'man_cmd_sect'}
			  : $config{'man_cmd'};
	}
$in{'page'} =~ s/\\/\\\\/g;
$in{'page'} =~ s/'/\\'/g;
$cmd =~ s/PAGE/'$in{'page'}'/;
if ($config{'strip_letters'}) {
	$in{'sec'} =~ s/^(\d+).*$/$1/;
	}
$cmd =~ s/SECTION/"$in{'sec'}"/;
if ($in{'opts'}) {
	$ENV{'MANPATH'} .= $config{'man_dir'}.':'.$in{'opts'};
	}
$out = `$cmd 2>&1`;
if ($out =~ /^.*no manual entry/i || $out =~ /^.*no entry/i ||
    $out =~ /^.*nothing appropriate/i) {
	print "<p><b>",&text('man_noentry', "<tt>$in{'page'}</tt>"),
	      "</b><p>\n";
	}
else {
	if (&has_command($config{'man2html_path'})) {
		$out =~ s/ .*//;
		$out =~ s/\n//;
		if( $out =~ /^.*\.gz/i ) {
			$cmd = "gunzip -c";
			}
		elsif ($out =~ /^.*\.bz2/i) {
			$cmd = "bunzip2 -c";
			}
		else {
			$cmd = "cat";
			}
		$cmd .= " $out | $config{'man2html_path'} -H \"\" -M \"view_man.cgi\"";
		$out = `$cmd 2>&1`;
		$out =~ s/^.*Content-type:.*\n//i;
		$out =~ s/http:\/\///ig;
		$out =~ s/\?/\?sec=/ig;
		$out =~ s/\+/&opts=$in{'opts'}&page=/ig;
		$out =~ s/<HTML>.*<BODY>//isg;
		$out =~ s/<\/HTML>//ig;
		$out =~ s/<\/BODY>//ig;
		$out =~ s/<A HREF="file:[^"]+">([^<]+)<\/a>/$1/ig;
		$out =~ s/<A HREF="view_man.cgi">/<A HREF=\"\">/i;
		print "<table border width=100%>\n";
		print "<tr $tb> <td><b>",&text('man_header', $in{'page'},
					       $in{'sec'}),"</b></td> </tr>\n";
		print "<tr $cb> <td>",$out,"</td> </tr>\n";
		print "</table>\n";
	} else {
		$out =~ s/.\010//g;
		$out =~ s/^(re)?formatting.*//i;
		$out =~ s/&/&amp;/g;
		$out =~ s/</&lt;/g;
		$out =~ s/>/&gt;/g;
		print "<table border width=100%>\n";
		print "<tr $tb> <td><b>",&text('man_header', $in{'page'},
					       $in{'sec'}),"</b></td> </tr>\n";
		print "<tr $cb> <td><pre>",$out,"</pre></td> </tr>\n";
		print "</table><p>\n";
		}
	}

print "<hr>\n";
&footer("", $text{'index_return'});

