/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2008 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#include "finditembatch.h"

#include "commands/command.h"

using namespace WebIssues;

FindItemBatch::FindItemBatch( int itemId ) : AbstractBatch( 0 ),
    m_issueId( 0 )
{
    Job job( &FindItemBatch::findItemJob );
    job.addArg( itemId );
    m_queue.addJob( job );
}

FindItemBatch::~FindItemBatch()
{
}

Command* FindItemBatch::fetchNext()
{
    if ( m_queue.moreJobs() )
        return m_queue.callJob( this );

    return NULL;
}

Command* FindItemBatch::findItemJob( const Job& job )
{
    Command* command = new Command();

    command->setKeyword( "FIND ITEM" );
    command->addArg( job.argInt( 0 ) );

    command->addRule( "ID i", ReplyRule::One );

    command->setAcceptNullReply( true );

    connect( command, SIGNAL( commandReply( const Reply& ) ), this, SLOT( findItemReply( const Reply& ) ) );

    return command;
}

void FindItemBatch::findItemReply( const Reply& reply )
{
    ReplyLine line = reply.lines().at( 0 );

    m_issueId = line.argInt( 0 );
}
