// WP_TRAY_SEARCH.C ////////////////////////////////////////////////////
//
// Author:				E^rthW( )rm 2003
// Last Mod:			Friday, September 05 2003
// About:				Callback handlers for the search tool dialog
// License:			GPL

// includes ////////////////////////////////////////////////////////////
//
#include <stdio.h>
#include <gtk/gtk.h>
#include <gnome.h>
#include <glade/glade.h>
#include <sys/types.h>
#include <dirent.h>
#include <gconf/gconf-client.h>
#include "config.h"
#include "../include/wp_tray_util.h"
#include "../include/wp_tray_search.h"

// globals /////////////////////////////////////////////////////////////
//
GladeXML 		* xml;						// pointer for xml interface loading

// types ///////////////////////////////////////////////////////////////
//
enum
{
	PATH_COLUMN,
	N_COLUMNS
};

// f_on_wp_search_pressed //////////////////////////////////////////////
//
// create search tool window on request 
void
f_on_wp_search_pressed			(GtkWidget *button, gpointer user_data)
{
	gchar						sz_xml_path[100];
	GtkWidget					* p_widget;
	GtkCellRenderer 			* renderer;
	GtkTreeViewColumn 			* column;
	GtkTreeStore				* tree_store;
	
	// create ui location string 
	snprintf(sz_xml_path, 100, "%s/wp_tray_search.glade", PACKAGE_DATA_DIR);
	
	// load the interface
    xml = glade_xml_new(sz_xml_path, NULL, NULL);
	
	// connect the signals in the interface
    glade_xml_signal_autoconnect(xml);
	
	// get list view
	p_widget = glade_xml_get_widget(xml, "treeview_results");
	
	// make a store to go with it
	tree_store = gtk_tree_store_new(N_COLUMNS,
                                   	G_TYPE_STRING);
									
	// attach the store to the view ...
	gtk_tree_view_set_model(GTK_TREE_VIEW(p_widget), GTK_TREE_MODEL(tree_store));
						
	// set up view to render new data
	renderer = gtk_cell_renderer_text_new();
	column = gtk_tree_view_column_new_with_attributes ("Result",
                                                   	   renderer,
                                                   	   "text", PATH_COLUMN,
                                                   	   NULL);
	// attach column renderer ...
	gtk_tree_view_append_column(GTK_TREE_VIEW(p_widget), column);
}// end f_on_wp_search_pressed

// f_on_button_find_pressed ////////////////////////////////////////////
//
void
f_on_button_find_pressed		(GtkWidget *button, gpointer user_data)
{
	GtkTreeIter 				iter;
	GtkWidget					* p_widget;
	GtkTreeStore				* tree_store;
	const gchar 				* sz_regex;
	GList						* ls_result, * ls_iter;
	GSList						* ls_wp_dir, * ls_s_iter;
	GConfClient					* p_gconf_client;
	gboolean					b_valid;
	GtkTreeIter					tree_iter;
	
	// grab notebook widget
	p_widget = glade_xml_get_widget(xml, "notebook1");

	// set the tab
	gtk_notebook_set_current_page(GTK_NOTEBOOK(p_widget), 1);
	
	// get list view
	p_widget = glade_xml_get_widget(xml, "treeview_results");
	
	// get associated tree store 
	tree_store = GTK_TREE_STORE(gtk_tree_view_get_model(GTK_TREE_VIEW(p_widget)));
	
	// clear it out if needed
	// get the first iter in the list
  	b_valid = gtk_tree_model_get_iter_first(GTK_TREE_MODEL(tree_store), &tree_iter);

  	while(b_valid)
    {
      	// walk through the list, reading each row
      	gchar 				* str_data;
		GtkTreeIter			prev_tree_iter;
		
		
      	gtk_tree_model_get(GTK_TREE_MODEL(tree_store), &tree_iter, 
                           PATH_COLUMN, &str_data,
                           -1);
		
		// free data 
		g_free(str_data);
		
		// save old one to delete later
		prev_tree_iter = tree_iter;
		
		// move on
      	b_valid = gtk_tree_model_iter_next(GTK_TREE_MODEL(tree_store), &tree_iter);

		// remove the bloody thing
		gtk_tree_store_remove(tree_store, &prev_tree_iter);
    }// end while
	
	// get default gconf client
	p_gconf_client = gconf_client_get_default();
	
	// get the search string
	sz_regex = gtk_entry_get_text(GTK_ENTRY(glade_xml_get_widget(xml, "combo-entry_search_text")));
	
	// get settings
	ls_wp_dir = gconf_client_get_list(p_gconf_client, "/apps/wp_tray/dir_list", GCONF_VALUE_STRING, NULL);
	
	// 'clear' the list
	ls_result = NULL;
	
	// build list of results
	for(ls_s_iter = ls_wp_dir; ls_s_iter != NULL; ls_s_iter = g_slist_next(ls_s_iter))
	{
		gchar				* sz_dir;
		
		// get data
		sz_dir = (gchar *)ls_s_iter->data;
		
		// search the directories for matches
		f_get_dir_regex_match_list(sz_dir, sz_regex, &ls_result);
		
		// free list data ...
		g_free(sz_dir);
	}// end for
	
	// kill the list
	g_slist_free(ls_wp_dir);
	
	// copy results list to the store
	for(ls_iter = ls_result; ls_iter != NULL; ls_iter = g_list_next(ls_iter))
	{
		gchar				* sz_result;
		
		// get data
		sz_result = (gchar *)ls_iter->data;
		
		// add a new row to the model
      	gtk_tree_store_append(tree_store, &iter, NULL);
      	gtk_tree_store_set(tree_store, &iter,
        	               PATH_COLUMN, sz_result,
                           -1);
		
		// free list data ...
		g_free(sz_result);
	}// end for
	
	// kill the list
	g_list_free(ls_result);
	
	// free up the gconf client (i think ...)
	g_object_unref(G_OBJECT(p_gconf_client));
}// end f_on_button_find_pressed	

// f_on_button_close_pressed ///////////////////////////////////////////
//
void
f_on_button_close_pressed		(GtkWidget *button, gpointer user_data)
{
	GtkTreeIter 				tree_iter;
	gboolean					b_valid;
	GtkTreeModel 				* p_tree_model;
	GtkWidget					* p_widget;
	
	// get list view
	p_widget = glade_xml_get_widget(xml, "treeview_results");
	
	// get associated tree store 
	p_tree_model = gtk_tree_view_get_model(GTK_TREE_VIEW(p_widget));
	
	// clear tree model out if needed
	// get the first iter in the list
  	b_valid = gtk_tree_model_get_iter_first(p_tree_model, &tree_iter);

  	while(b_valid)
    {
      	// walk through the list, reading each row
      	gchar 				* str_data;
		GtkTreeIter			prev_tree_iter;
		
		
      	gtk_tree_model_get(p_tree_model, &tree_iter, 
                           PATH_COLUMN, &str_data,
                           -1);
		
		// free data 
		g_free(str_data);
		
		// save old one to delete later
		prev_tree_iter = tree_iter;
		
		// move on
      	b_valid = gtk_tree_model_iter_next(p_tree_model, &tree_iter);

		// remove the bloody thing
		gtk_tree_store_remove(GTK_TREE_STORE(p_tree_model), &prev_tree_iter);
    }// end while
	
	// kill the window and the xml etc
	g_object_unref(G_OBJECT(p_tree_model));
	gtk_widget_destroy(glade_xml_get_widget(xml, "window1"));
	g_object_unref(G_OBJECT(xml));
}// end f_on_button_close_pressed

// f_on_button_apply_pressed ///////////////////////////////////////////
//
void
f_on_button_apply_pressed		(GtkWidget *button, gpointer user_data)
{
	GtkTreeIter 				tree_iter;
	gboolean					b_valid, b_new_wp;
	GtkTreeModel 				* p_tree_model;
	GtkTreePath 				* p_tree_path;
	GtkTreeSelection 			* p_tree_selection;
	GtkWidget					* p_widget;
	GList						* ls_selected_rows, * ls_iter;
	
	// get list view
	p_widget = glade_xml_get_widget(xml, "treeview_results");
	
	// get selection pointer for tree view
	p_tree_selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(p_widget));
	
	// get a list of selected rows 
	ls_selected_rows =
	gtk_tree_selection_get_selected_rows(p_tree_selection, &p_tree_model);
	
	// no new wallpaper unless current one is deleted
	b_new_wp = FALSE;
	
	// iterate the list
	for(ls_iter = ls_selected_rows; ls_iter != NULL; ls_iter = g_list_next(ls_iter))
	{
		gchar 				* sz_path;
		
		// type safe pointer
		p_tree_path = (GtkTreePath *)(ls_iter->data);
		
		// get a tree iterator at this point
		gtk_tree_model_get_iter(p_tree_model, &tree_iter, p_tree_path);
		
		// get the actual data at this point
      	gtk_tree_model_get(p_tree_model, &tree_iter, 
                           PATH_COLUMN, &sz_path,
                           -1);
		
		// what are we doing with this?
		// get toggle widget
		p_widget = glade_xml_get_widget(xml, "radiobutton_delete");
		
		// delete ?
		if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(p_widget)))
		{
			// get gconf client and get the wp string
			GConfClient * client = gconf_client_get_default();	
			gchar * sz_current   = gconf_client_get_string(client, "/desktop/gnome/background/picture_filename", NULL);
			
			// ditch reference 
			g_object_unref(G_OBJECT(client));
			
			// kill the wallpaper
			remove(sz_path);
			
			// just deleted the current wallpaper?
			b_new_wp |= (strcmp(sz_current, sz_path) == 0);
		}// end if 
		
		// get toggle widget 
		p_widget = glade_xml_get_widget(xml, "radiobutton_select");
		
		// select ?
		if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(p_widget)))
		{
			// get gconf client and set the string to the new wp
			GConfClient * client = gconf_client_get_default();	
			gconf_client_set_string(client, "/desktop/gnome/background/picture_filename",
       		              			sz_path, NULL);
			
			// ditch reference 
			g_object_unref(G_OBJECT(client));
		}// end if
	}// end for
	
	// time for a new wallpaper
	if(b_new_wp)
		f_set_rand_wallpaper(button, user_data);
	
	// get list view
	p_widget = glade_xml_get_widget(xml, "treeview_results");
	
	// get associated tree store 
	p_tree_model = gtk_tree_view_get_model(GTK_TREE_VIEW(p_widget));
	
	// clear tree model out if needed
	// get the first iter in the list
  	b_valid = gtk_tree_model_get_iter_first(p_tree_model, &tree_iter);

  	while(b_valid)
    {
      	// walk through the list, reading each row
      	gchar 				* str_data;
		GtkTreeIter			prev_tree_iter;
		
		
      	gtk_tree_model_get(p_tree_model, &tree_iter, 
                           PATH_COLUMN, &str_data,
                           -1);
		
		// free data 
		g_free(str_data);
		
		// save old one to delete later
		prev_tree_iter = tree_iter;
		
		// move on
      	b_valid = gtk_tree_model_iter_next(p_tree_model, &tree_iter);

		// remove the bloody thing
		gtk_tree_store_remove(GTK_TREE_STORE(p_tree_model), &prev_tree_iter);
    }// end while
	
	// kill the window and the xml etc
	g_object_unref(G_OBJECT(p_tree_model));
	gtk_widget_destroy(glade_xml_get_widget(xml, "window1"));
	g_object_unref(G_OBJECT(xml));
}// end f_on_button_apply_pressed

// f_on_button_cancel_pressed //////////////////////////////////////////
//
void
f_on_button_cancel_pressed		(GtkWidget *button, gpointer user_data)
{
	GtkTreeIter 				tree_iter;
	gboolean					b_valid;
	GtkTreeModel 				* p_tree_model;
	GtkWidget					* p_widget;
	
	// get list view
	p_widget = glade_xml_get_widget(xml, "treeview_results");
	
	// get associated tree store 
	p_tree_model = gtk_tree_view_get_model(GTK_TREE_VIEW(p_widget));
	
	// clear tree model out if needed
	// get the first iter in the list
  	b_valid = gtk_tree_model_get_iter_first(p_tree_model, &tree_iter);

  	while(b_valid)
    {
      	// walk through the list, reading each row
      	gchar 				* str_data;
		GtkTreeIter			prev_tree_iter;
		
		
      	gtk_tree_model_get(p_tree_model, &tree_iter, 
                           PATH_COLUMN, &str_data,
                           -1);
		
		// free data 
		g_free(str_data);
		
		// save old one to delete later
		prev_tree_iter = tree_iter;
		
		// move on
      	b_valid = gtk_tree_model_iter_next(p_tree_model, &tree_iter);

		// remove the bloody thing
		gtk_tree_store_remove(GTK_TREE_STORE(p_tree_model), &prev_tree_iter);
    }// end while
	
	// kill the window and the xml etc
	g_object_unref(G_OBJECT(p_tree_model));
	gtk_widget_destroy(glade_xml_get_widget(xml, "window1"));
	g_object_unref(G_OBJECT(xml));
}// end f_on_button_apply_pressed

// f_on_radiobutton_delete_toggled /////////////////////////////////////
//
void
f_on_radiobutton_delete_toggled	(GtkWidget *button, gpointer user_data)
{
	GtkTreeSelection			* p_tree_selection;
	GtkWidget					* p_widget;
	
	// get list view
	p_widget = glade_xml_get_widget(xml, "treeview_results");
	
	// get selection pointer for tree view
	p_tree_selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(p_widget));
	
	// allow multiple selection 
	gtk_tree_selection_set_mode(p_tree_selection, GTK_SELECTION_MULTIPLE);
}// end f_on_radiobutton_delete_toggled

// f_on_radiobutton_select_toggled /////////////////////////////////////
//
void
f_on_radiobutton_select_toggled	(GtkWidget *button, gpointer user_data)
{
	GtkTreeSelection			* p_tree_selection;
	GtkWidget					* p_widget;
	
	// get list view
	p_widget = glade_xml_get_widget(xml, "treeview_results");
	
	// get selection pointer for tree view
	p_tree_selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(p_widget));
	
	// dis-allow multiple selection 
	gtk_tree_selection_set_mode(p_tree_selection, GTK_SELECTION_SINGLE);
}// end f_on_radiobutton_select_toggled
