
/* 
 * Lynx-like key binding.
 *
 * modified from original keybind.c by Keisuke Hashimoto
 * <hasimoto@shimada.nuee.nagoya-u.ac.jp>
 * http://www.shimada.nuee.nagoya-u.ac.jp/~hasimoto/
 *
 * further modification by Akinori Ito
 *
 * Date: Tue, 23 Feb 1999 13:14:44 +0900
 */

#include "fm.h"

static KeyTabItem w3mDefaultFuncKeyTab[] = {
  K_SET_FUNC(K_GEN(0, K_CTL_ATMARK), FUNCNAME__mark),
  K_SET_FUNC(K_GEN(0, K_CTL_A), FUNCNAME_goLineF),
  K_SET_FUNC(K_GEN(0, K_CTL_B), FUNCNAME_backBf),
  K_SET_FUNC(K_GEN(0, K_CTL_E), FUNCNAME_goLineL),
  K_SET_FUNC(K_GEN(0, K_CTL_F), FUNCNAME_followA),
  K_SET_FUNC(K_GEN(0, K_CTL_G), FUNCNAME_curlno),
  K_SET_FUNC(K_GEN(0, K_CTL_H), FUNCNAME_ldHist),
  K_SET_FUNC(K_GEN(0, K_CTL_I), FUNCNAME_next_frame),
  K_SET_FUNC(K_GEN(0, K_CTL_J), FUNCNAME_followA),
  K_SET_FUNC(K_GEN(0, K_CTL_K), FUNCNAME_cooLst),
  K_SET_FUNC(K_GEN(0, K_CTL_L), FUNCNAME_rdrwSc),
  K_SET_FUNC(K_GEN(0, K_CTL_M), FUNCNAME_followA),
  K_SET_FUNC(K_GEN(0, K_CTL_N), FUNCNAME_nextA),
  K_SET_FUNC(K_GEN(0, K_CTL_P), FUNCNAME_prevA),
  K_SET_FUNC(K_GEN(0, K_CTL_R), FUNCNAME_reload_view),
  K_SET_FUNC(K_GEN(0, K_CTL_S), FUNCNAME_srchfor),
  K_SET_FUNC(K_GEN(0, K_CTL_V), FUNCNAME_pgFore),
  K_SET_FUNC(K_GEN(0, K_CTL_W), FUNCNAME_rdrwSc),
  K_SET_FUNC(K_GEN(0, K_CTL_Z), FUNCNAME_susp),
  K_SET_FUNC(K_GEN(0, K_CTL_LBRACKET), FUNCNAME_escmap),
  K_SET_FUNC(K_GEN(0, K_SPACE), FUNCNAME_pgFore),
  K_SET_FUNC(K_GEN(0, K_SYM_EXCLM), FUNCNAME_execsh),
  K_SET_FUNC(K_GEN(0, K_SYM_DQ), FUNCNAME_reMark),
  K_SET_FUNC(K_GEN(0, K_SYM_SHARP), FUNCNAME_pipesh),
  K_SET_FUNC(K_GEN(0, K_SYM_DOLLAR), FUNCNAME_linend),
  K_SET_FUNC(K_GEN(0, K_SYM_PLUS), FUNCNAME_pgFore),
  K_SET_FUNC(K_GEN(0, K_SYM_MINUS), FUNCNAME_pgBack),
  K_SET_FUNC(K_GEN(0, K_SYM_SLASH), FUNCNAME_srchfor),
  K_SET_FUNC(K_GEN(0, K_SYM_COLON), FUNCNAME_chkURL),
  K_SET_FUNC(K_GEN(0, K_SYM_LT), FUNCNAME_shiftl),
  K_SET_FUNC(K_GEN(0, K_SYM_EQ), FUNCNAME_pginfo),
  K_SET_FUNC(K_GEN(0, K_SYM_GT), FUNCNAME_shiftr),
  K_SET_FUNC(K_GEN(0, K_SYM_QUESTION), FUNCNAME_ldhelp),
  K_SET_FUNC(K_GEN(0, K_SYM_ATMARK), FUNCNAME_readsh),
  K_SET_FUNC(K_GEN(0, K_ALPHA_B), FUNCNAME_backBf),
  K_SET_FUNC(K_GEN(0, K_ALPHA_E), FUNCNAME_editBf),
  K_SET_FUNC(K_GEN(0, K_ALPHA_F), FUNCNAME_rFrame),
  K_SET_FUNC(K_GEN(0, K_ALPHA_G), FUNCNAME_goLine),
  K_SET_FUNC(K_GEN(0, K_ALPHA_H), FUNCNAME_ldhelp),
  K_SET_FUNC(K_GEN(0, K_ALPHA_I), FUNCNAME_followI),
  K_SET_FUNC(K_GEN(0, K_ALPHA_J), FUNCNAME_lup1),
  K_SET_FUNC(K_GEN(0, K_ALPHA_K), FUNCNAME_ldown1),
  K_SET_FUNC(K_GEN(0, K_ALPHA_M), FUNCNAME_extbrz),
  K_SET_FUNC(K_GEN(0, K_ALPHA_N), FUNCNAME_nextMk),
  K_SET_FUNC(K_GEN(0, K_ALPHA_P), FUNCNAME_prevMk),
  K_SET_FUNC(K_GEN(0, K_ALPHA_Q), FUNCNAME_quitfm),
  K_SET_FUNC(K_GEN(0, K_ALPHA_R), FUNCNAME_reload_view),
  K_SET_FUNC(K_GEN(0, K_ALPHA_S), FUNCNAME_svBuf),
  K_SET_FUNC(K_GEN(0, K_ALPHA_U), FUNCNAME_goURL),
  K_SET_FUNC(K_GEN(0, K_ALPHA_V), FUNCNAME_ldfile),
  K_SET_FUNC(K_GEN(0, K_ALPHA_Z), FUNCNAME_ctrCsrH),
  K_SET_FUNC(K_GEN(0, K_SYM_BACKSLASH), FUNCNAME_vwSrc),
  K_SET_FUNC(K_GEN(0, K_SYM_HAT), FUNCNAME_linbeg),
  K_SET_FUNC(K_GEN(0, K_ALPHA_a), FUNCNAME_adBmark),
  K_SET_FUNC(K_GEN(0, K_ALPHA_b), FUNCNAME_pgBack),
  K_SET_FUNC(K_GEN(0, K_ALPHA_c), FUNCNAME_curURL),
  K_SET_FUNC(K_GEN(0, K_ALPHA_d), FUNCNAME_svA),
  K_SET_FUNC(K_GEN(0, K_ALPHA_g), FUNCNAME_goURL),
  K_SET_FUNC(K_GEN(0, K_ALPHA_h), FUNCNAME_movL),
  K_SET_FUNC(K_GEN(0, K_ALPHA_i), FUNCNAME_peekIMG),
  K_SET_FUNC(K_GEN(0, K_ALPHA_j), FUNCNAME_movD),
  K_SET_FUNC(K_GEN(0, K_ALPHA_k), FUNCNAME_movU),
  K_SET_FUNC(K_GEN(0, K_ALPHA_l), FUNCNAME_movR),
  K_SET_FUNC(K_GEN(0, K_ALPHA_n), FUNCNAME_srchnxt),
  K_SET_FUNC(K_GEN(0, K_ALPHA_o), FUNCNAME_ldOpt),
  K_SET_FUNC(K_GEN(0, K_ALPHA_p), FUNCNAME_svBuf),
  K_SET_FUNC(K_GEN(0, K_ALPHA_q), FUNCNAME_qquitfm),
  K_SET_FUNC(K_GEN(0, K_ALPHA_s), FUNCNAME_selMn),
  K_SET_FUNC(K_GEN(0, K_ALPHA_u), FUNCNAME_peekURL),
  K_SET_FUNC(K_GEN(0, K_ALPHA_v), FUNCNAME_ldBmark),
  K_SET_FUNC(K_GEN(0, K_ALPHA_w), FUNCNAME_wrapToggle),
  K_SET_FUNC(K_GEN(0, K_ALPHA_z), FUNCNAME_ctrCsrV),
  K_SET_FUNC(K_GEN(0, K_ESC | K_CTL_I), FUNCNAME_prev_frame),
  K_SET_FUNC(K_GEN(0, K_ESC | K_CTL_J), FUNCNAME_svA),
  K_SET_FUNC(K_GEN(0, K_ESC | K_CTL_M), FUNCNAME_svA),
  K_SET_FUNC(K_GEN(0, K_ESC | K_SYM_COLON), FUNCNAME_chkNMID),
  K_SET_FUNC(K_GEN(0, K_ESC | K_ALPHA_I), FUNCNAME_svI),
  K_SET_FUNC(K_GEN(0, K_ESC | K_ALPHA_M), FUNCNAME_linkbrz),
  K_SET_FUNC(K_GEN(0, K_ESC | K_ALPHA_O), FUNCNAME_escbmap),
  K_SET_FUNC(K_GEN(0, K_ESC | K_SYM_LBRACKET), FUNCNAME_escbmap),
  K_SET_FUNC(K_GEN(0, K_ESC | K_ALPHA_a), FUNCNAME_adBmark),
  K_SET_FUNC(K_GEN(0, K_ESC | K_ALPHA_b), FUNCNAME_ldBmark),
  K_SET_FUNC(K_GEN(0, K_ESC | K_ALPHA_e), FUNCNAME_editScr),
  K_SET_FUNC(K_GEN(0, K_ESC | K_ALPHA_s), FUNCNAME_svSrc),
  K_SET_FUNC(K_GEN(0, K_ESC | K_ALPHA_u), FUNCNAME_gorURL),
  K_SET_FUNC(K_GEN(0, K_ESC | K_ALPHA_v), FUNCNAME_pgBack),
  K_SET_FUNC(K_GEN(0, K_ESC | K_ALPHA_x), FUNCNAME_callfunc),
  K_SET_FUNC(K_GEN(0, K_UP), FUNCNAME_prevA),
  K_SET_FUNC(K_GEN(0, K_DOWN), FUNCNAME_nextA),
  K_SET_FUNC(K_GEN(0, K_RIGHT), FUNCNAME_followA),
  K_SET_FUNC(K_GEN(0, K_LEFT), FUNCNAME_backBf),
  K_SET_FUNC(K_GEN(0, K_XTERM_MOUSE), FUNCNAME_mouse),
  K_SET_FUNC(K_GEN(0, K_PAD_HOME), FUNCNAME_goLineF),
  K_SET_FUNC(K_GEN(0, K_PAD_INS), FUNCNAME_mainMn),
  K_SET_FUNC(K_GEN(0, K_PAD_END), FUNCNAME_goLineL),
  K_SET_FUNC(K_GEN(0, K_PAD_PGUP), FUNCNAME_pgBack),
  K_SET_FUNC(K_GEN(0, K_PAD_PGDN), FUNCNAME_pgFore),
  K_SET_FUNC(K_GEN(0, K_PAD_HELP), FUNCNAME_mainMn),
#ifdef USE_MOUSE
  K_SET_FUNC(K_GEN(0, K_MOUSE(CLICK) + MOUSE_BTN1_DOWN), FUNCNAME_gotoXY),
  K_SET_FUNC(K_GEN(0, K_MOUSE(CLICK) + MOUSE_BTN2_DOWN), FUNCNAME_backBf),
  K_SET_FUNC(K_GEN(0, K_MOUSE(CLICK) + MOUSE_BTN3_DOWN), FUNCNAME_mainMn),
  K_SET_FUNC(K_GEN(0, K_MOUSE(CLICK) + MOUSE_BTN4_DOWN), FUNCNAME_ldown1),
  K_SET_FUNC(K_GEN(0, K_MOUSE(CLICK) + MOUSE_BTN5_DOWN), FUNCNAME_lup1),
  K_SET_FUNC(K_GEN(0, K_MOUSE(DCLICK) + MOUSE_BTN1_DOWN), FUNCNAME_followA),
  K_SET_FUNC(K_GEN(0, K_MOUSE(DCLICK) + MOUSE_BTN2_DOWN), FUNCNAME_backBf),
  K_SET_FUNC(K_GEN(0, K_MOUSE(DCLICK) + MOUSE_BTN3_DOWN), FUNCNAME_mainMn),
  K_SET_FUNC(K_GEN(0, K_MOUSE(DRAG) + MOUSE_BTN1_DOWN), FUNCNAME_scrollXY),
  K_SET_FUNC(K_GEN(0, K_MOUSE(DRAG) + MOUSE_BTN2_DOWN), FUNCNAME_backBf),
  K_SET_FUNC(K_GEN(0, K_MOUSE(DRAG) + MOUSE_BTN3_DOWN), FUNCNAME_mainMn),
  K_SET_FUNC(K_GEN(0, K_MOUSE(MOVE) + MOUSE_BTN1_DOWN), FUNCNAME_scrollXY),
#endif
};

KeyTabList w3mDefaultFuncKeyTabList = {
  NULL,
  w3mDefaultFuncKeyTab,
  sizeof(w3mDefaultFuncKeyTab) / sizeof(w3mDefaultFuncKeyTab[0]),
  sizeof(w3mDefaultFuncKeyTab) / sizeof(w3mDefaultFuncKeyTab[0]),
};
