/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.ui.navigation;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import org.j3d.ui.navigation.NavigationMouseProcessor;
import org.j3d.ui.navigation.NavigationStateListener;
import org.j3d.ui.navigation.NavigationToolbar;
import org.j3d.util.ImageLoader;

public class NavigationStateManager {
    private static final String PAN_CURSOR = "images/navigation/CursorPan.gif";
    private static final String TILT_CURSOR = "images/navigation/CursorTilt.gif";
    private static final String WALK_CURSOR = "images/navigation/CursorWalk.gif";
    private static final String FLY_CURSOR = "images/navigation/CursorFly.gif";
    private static final String EXAMINE_CURSOR = "images/navigation/CursorExamine.gif";
    private Component canvas;
    private Cursor panCursor = null;
    private Cursor tiltCursor = null;
    private Cursor walkCursor = null;
    private Cursor flyCursor = null;
    private Cursor examineCursor = null;
    private Cursor previousCursor;
    private int navigationState;
    private NavigationMouseProcessor mouseHandler;
    private NavigationToolbar toolbarHandler;
    private NavigationStateListener navigationListener;

    public NavigationStateManager(Component component) {
        if (component == null) {
            throw new IllegalArgumentException("Null canvas provided");
        }
        this.canvas = component;
        this.loadCursors();
        this.previousCursor = component.getCursor();
        this.setNavigationState(0);
    }

    public void setToolbar(NavigationToolbar navigationToolbar) {
        if (this.toolbarHandler != null) {
            this.toolbarHandler.setNavigationStateListener(null);
        }
        this.toolbarHandler = navigationToolbar;
        if (this.toolbarHandler != null) {
            this.toolbarHandler.setNavigationStateListener(new ToolbarHandler());
            this.toolbarHandler.setNavigationState(this.navigationState);
        }
    }

    public void setMouseHandler(NavigationMouseProcessor navigationMouseProcessor) {
        if (this.mouseHandler != null) {
            this.mouseHandler.setNavigationStateListener(null);
        }
        this.mouseHandler = navigationMouseProcessor;
        if (this.mouseHandler != null) {
            this.mouseHandler.setNavigationStateListener(new MouseHandler());
        }
    }

    public void setNavigationStateListener(NavigationStateListener navigationStateListener) {
        this.navigationListener = navigationStateListener;
    }

    public void setNavigationState(int n) {
        this.navigationState = n;
        switch (this.navigationState) {
            case 1: {
                this.previousCursor = this.canvas.getCursor();
                this.canvas.setCursor(this.walkCursor);
                break;
            }
            case 3: {
                this.previousCursor = this.canvas.getCursor();
                this.canvas.setCursor(this.panCursor);
                break;
            }
            case 2: {
                this.previousCursor = this.canvas.getCursor();
                this.canvas.setCursor(this.tiltCursor);
                break;
            }
            case 4: {
                this.previousCursor = this.canvas.getCursor();
                this.canvas.setCursor(this.flyCursor);
                break;
            }
            case 5: {
                this.previousCursor = this.canvas.getCursor();
                this.canvas.setCursor(this.examineCursor);
                break;
            }
            case 0: {
                this.canvas.setCursor(this.previousCursor);
            }
        }
        if (this.toolbarHandler != null) {
            this.toolbarHandler.setNavigationState(n);
        }
        if (this.navigationListener != null) {
            this.navigationListener.setNavigationState(n);
        }
    }

    public int getNavigationState() {
        return this.navigationState;
    }

    private void loadCursors() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Image image = ImageLoader.loadImage(PAN_CURSOR);
        Point point = new Point();
        if (image != null) {
            point.x = image.getWidth(null) / 2;
            point.y = image.getHeight(null) / 2;
            this.panCursor = toolkit.createCustomCursor(image, point, null);
        } else {
            System.out.println("Unable to load pan cursor image");
        }
        image = ImageLoader.loadImage(WALK_CURSOR);
        point = new Point();
        if (image != null) {
            point.x = image.getWidth(null) / 2;
            point.y = image.getHeight(null) / 2;
            this.walkCursor = toolkit.createCustomCursor(image, point, null);
        } else {
            System.out.println("Unable to load walk cursor image");
        }
        image = ImageLoader.loadImage(TILT_CURSOR);
        point = new Point();
        if (image != null) {
            point.x = image.getWidth(null) / 2;
            point.y = image.getHeight(null) / 2;
            this.tiltCursor = toolkit.createCustomCursor(image, point, null);
        } else {
            System.out.println("Unable to load tilt cursor image");
        }
        image = ImageLoader.loadImage(FLY_CURSOR);
        point = new Point();
        if (image != null) {
            point.x = image.getWidth(null) / 2;
            point.y = image.getHeight(null) / 2;
            this.flyCursor = toolkit.createCustomCursor(image, point, null);
        } else {
            System.out.println("Unable to load fly cursor image");
        }
        image = ImageLoader.loadImage(EXAMINE_CURSOR);
        point = new Point();
        if (image != null) {
            point.x = image.getWidth(null) / 2;
            point.y = image.getHeight(null) / 2;
            this.examineCursor = toolkit.createCustomCursor(image, point, null);
        } else {
            System.out.println("Unable to load examine cursor image");
        }
    }

    private class MouseHandler
    implements NavigationStateListener {
        private MouseHandler() {
        }

        public void setNavigationState(int n) {
            NavigationStateManager.this.navigationState = n;
            switch (NavigationStateManager.this.navigationState) {
                case 1: {
                    NavigationStateManager.this.previousCursor = NavigationStateManager.this.canvas.getCursor();
                    NavigationStateManager.this.canvas.setCursor(NavigationStateManager.this.walkCursor);
                    break;
                }
                case 3: {
                    NavigationStateManager.this.previousCursor = NavigationStateManager.this.canvas.getCursor();
                    NavigationStateManager.this.canvas.setCursor(NavigationStateManager.this.panCursor);
                    break;
                }
                case 2: {
                    NavigationStateManager.this.previousCursor = NavigationStateManager.this.canvas.getCursor();
                    NavigationStateManager.this.canvas.setCursor(NavigationStateManager.this.tiltCursor);
                    break;
                }
                case 4: {
                    NavigationStateManager.this.previousCursor = NavigationStateManager.this.canvas.getCursor();
                    NavigationStateManager.this.canvas.setCursor(NavigationStateManager.this.flyCursor);
                    break;
                }
                case 5: {
                    NavigationStateManager.this.previousCursor = NavigationStateManager.this.canvas.getCursor();
                    NavigationStateManager.this.canvas.setCursor(NavigationStateManager.this.examineCursor);
                    break;
                }
                case 0: {
                    NavigationStateManager.this.canvas.setCursor(NavigationStateManager.this.previousCursor);
                }
            }
            if (NavigationStateManager.this.toolbarHandler != null) {
                NavigationStateManager.this.toolbarHandler.setNavigationState(n);
            }
            if (NavigationStateManager.this.navigationListener != null) {
                NavigationStateManager.this.navigationListener.setNavigationState(n);
            }
        }

        public int getNavigationState() {
            return NavigationStateManager.this.navigationState;
        }
    }

    private class ToolbarHandler
    implements NavigationStateListener {
        private ToolbarHandler() {
        }

        public void setNavigationState(int n) {
            NavigationStateManager.this.navigationState = n;
            switch (NavigationStateManager.this.navigationState) {
                case 1: {
                    NavigationStateManager.this.previousCursor = NavigationStateManager.this.canvas.getCursor();
                    NavigationStateManager.this.canvas.setCursor(NavigationStateManager.this.walkCursor);
                    break;
                }
                case 3: {
                    NavigationStateManager.this.previousCursor = NavigationStateManager.this.canvas.getCursor();
                    NavigationStateManager.this.canvas.setCursor(NavigationStateManager.this.panCursor);
                    break;
                }
                case 2: {
                    NavigationStateManager.this.previousCursor = NavigationStateManager.this.canvas.getCursor();
                    NavigationStateManager.this.canvas.setCursor(NavigationStateManager.this.tiltCursor);
                    break;
                }
                case 4: {
                    NavigationStateManager.this.previousCursor = NavigationStateManager.this.canvas.getCursor();
                    NavigationStateManager.this.canvas.setCursor(NavigationStateManager.this.flyCursor);
                    break;
                }
                case 5: {
                    NavigationStateManager.this.previousCursor = NavigationStateManager.this.canvas.getCursor();
                    NavigationStateManager.this.canvas.setCursor(NavigationStateManager.this.examineCursor);
                    break;
                }
                case 0: {
                    NavigationStateManager.this.canvas.setCursor(NavigationStateManager.this.previousCursor);
                }
            }
            if (NavigationStateManager.this.mouseHandler != null) {
                NavigationStateManager.this.mouseHandler.setButtonNavigation(16, n);
            }
            if (NavigationStateManager.this.navigationListener != null) {
                NavigationStateManager.this.navigationListener.setNavigationState(n);
            }
        }

        public int getNavigationState() {
            return NavigationStateManager.this.navigationState;
        }
    }
}

